/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.datafaker.Faker;

public class Time {
    private final Faker faker;

    protected Time(Faker faker) {
        this.faker = faker;
    }

    public long future(int atMost, ChronoUnit unit) {
        long atMostTime = LocalTime.now().plus(atMost, unit).toNanoOfDay();
        long time = LocalTime.now().toNanoOfDay();
        return this.faker.number().numberBetween(time, atMostTime);
    }

    public String future(int atMost, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.future(atMost, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long future(int atMost, int minimum, ChronoUnit unit) {
        long atMostTime = LocalTime.now().plus(atMost, unit).toNanoOfDay();
        long time = LocalTime.now().plus(minimum, unit).toNanoOfDay();
        return this.faker.number().numberBetween(time, atMostTime);
    }

    public String future(int atMost, int minimum, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.future(atMost, minimum, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long past(int atLeast, ChronoUnit unit) {
        long atLeastTime = LocalTime.now().minus(atLeast, unit).toNanoOfDay();
        long time = LocalTime.now().toNanoOfDay();
        return this.faker.number().numberBetween(atLeastTime, time);
    }

    public String past(int atMost, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.past(atMost, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long past(int atMost, int minimum, ChronoUnit unit) {
        long atMostTime = LocalTime.now().minus(atMost, unit).toNanoOfDay();
        long time = LocalTime.now().minus(minimum, unit).toNanoOfDay();
        return this.faker.number().numberBetween(atMostTime, time);
    }

    public String past(int atMost, int minimum, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.past(atMost, minimum, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long between(LocalTime from, LocalTime to) throws IllegalArgumentException {
        if (to.isBefore(from)) {
            throw new IllegalArgumentException("Invalid time range, the upper bound time is before the lower bound.");
        }
        if (from.equals(to)) {
            return from.toNanoOfDay();
        }
        return this.faker.number().numberBetween(from.toNanoOfDay(), to.toNanoOfDay());
    }

    public String between(LocalTime from, LocalTime to, String pattern) throws IllegalArgumentException {
        return LocalTime.ofNanoOfDay(this.between(from, to)).format(DateTimeFormatter.ofPattern(pattern));
    }
}

