/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.datafaker.Faker;
import net.datafaker.service.RandomService;

public class Twitter {
    private final Faker faker;
    private final String basicstr = "QabR0cYdZ1efSg2hi3jNOPkTUM4VLlmXK5nJo6WIpHGqF7rEs8tDuC9vwBxAyz";

    protected Twitter(Faker faker) {
        this.faker = faker;
    }

    public Date createdTime(boolean forward, Date base, Date constrains) {
        RandomService random = this.faker.random();
        if (forward) {
            return new Date(base.getTime() + (long)(random.nextDouble() * (double)(constrains.getTime() - base.getTime())));
        }
        return new Date(base.getTime() - (long)(random.nextDouble() * (double)(base.getTime() - constrains.getTime())));
    }

    public String twitterId(int expectedLength) {
        int hashCodeV;
        if (expectedLength <= 6 || expectedLength >= 25) {
            Logger logger = Logger.getLogger(Twitter.class.getName());
            logger.setLevel(Level.WARNING);
            logger.warning("expectedLength <= 6 may easily cause twitter id collision. And expectedLength >= 25 can be easily out of bound.");
        }
        if ((hashCodeV = UUID.randomUUID().toString().hashCode()) < 0) {
            hashCodeV = -hashCodeV;
        }
        String id1 = String.valueOf(hashCodeV);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String newDate = sdf.format(new Date());
        String result = "";
        RandomService random = this.faker.random();
        for (int i = 0; i < expectedLength - id1.length() - newDate.length(); ++i) {
            result = result.concat(String.valueOf(random.nextInt(10)));
        }
        String id2 = result + newDate;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = 0;
        while (i < id1.length() || j < id2.length()) {
            if (i < id1.length()) {
                sb.append(id1.charAt(i++));
            }
            if (j >= id2.length()) continue;
            sb.append(id2.charAt(j++));
        }
        String id = sb.toString();
        int start = random.nextInt(id.length() - expectedLength + 1);
        id = id.substring(start, start + expectedLength);
        return id;
    }

    public String text(String[] keywords, int sentenceMaxLength, int wordMaxLength) {
        if (wordMaxLength <= 2) {
            Logger logger = Logger.getLogger(Twitter.class.getName());
            logger.setLevel(Level.WARNING);
            logger.warning("Word length less than 2 is dangerous. Exceptions can be raised.");
        }
        ArrayList<String> text = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        RandomService random = this.faker.random();
        int sentenceLength = random.nextInt(1, sentenceMaxLength);
        for (int i = 0; i < sentenceLength; ++i) {
            int tmpWordLength = random.nextInt(3, wordMaxLength);
            for (int j = 0; j < tmpWordLength; ++j) {
                sb.append("QabR0cYdZ1efSg2hi3jNOPkTUM4VLlmXK5nJo6WIpHGqF7rEs8tDuC9vwBxAyz".charAt(random.nextInt("QabR0cYdZ1efSg2hi3jNOPkTUM4VLlmXK5nJo6WIpHGqF7rEs8tDuC9vwBxAyz".length())));
            }
            text.add(sb.toString());
            sb.setLength(0);
        }
        if (keywords != null && keywords.length > 0) {
            for (String keyword : keywords) {
                int position = random.nextInt(text.size());
                text.add(position, keyword);
            }
        }
        return String.join((CharSequence)" ", text);
    }

    public String userName() {
        return this.faker.fakeValuesService().resolve("twitter.user_name", this, this.faker);
    }

    public String userId() {
        return this.faker.fakeValuesService().resolve("twitter.user_id", this, this.faker);
    }

    public String getLink(String username, int extraLength) {
        if (extraLength <= 4) {
            Logger logger = Logger.getLogger(Twitter.class.getName());
            logger.setLevel(Level.WARNING);
            logger.warning("Extra length <=4 can cause collision.");
        }
        RandomService random = this.faker.random();
        StringBuilder sb = new StringBuilder();
        sb.append(username).append("/");
        for (int i = 0; i < extraLength; ++i) {
            sb.append("QabR0cYdZ1efSg2hi3jNOPkTUM4VLlmXK5nJo6WIpHGqF7rEs8tDuC9vwBxAyz".charAt(random.nextInt("QabR0cYdZ1efSg2hi3jNOPkTUM4VLlmXK5nJo6WIpHGqF7rEs8tDuC9vwBxAyz".length())));
        }
        return "https://twitter.com/" + sb;
    }
}

