/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.datafaker.Faker;

public class Vehicle {
    private final Faker faker;
    static final String VIN_REGEX = "([A-HJ-NPR-Z0-9]){3}[A-HJ-NPR-Z0-9]{5}[A-HJ-NPR-Z0-9]{1}[A-HJ-NPR-Z0-9]{1}[A-HJ-NPR-Z0-0]{1}[A-HJ-NPR-Z0-9]{1}\\d{5}";

    public Vehicle(Faker faker) {
        this.faker = faker;
    }

    public String vin() {
        return this.faker.fakeValuesService().regexify(VIN_REGEX);
    }

    public String manufacturer() {
        return this.faker.resolve("vehicle.manufacture");
    }

    public String make() {
        return this.faker.resolve("vehicle.makes");
    }

    public String model() {
        return this.model(this.make());
    }

    public String model(String make) {
        return this.faker.resolve("vehicle.models_by_make." + make);
    }

    public String makeAndModel() {
        String make = this.make();
        return make + " " + this.model(make);
    }

    public String style() {
        return this.faker.resolve("vehicle.styles");
    }

    public String color() {
        return this.faker.resolve("vehicle.colors");
    }

    public String transmission() {
        return this.faker.resolve("vehicle.transmissions");
    }

    public String driveType() {
        return this.faker.resolve("vehicle.drive_types");
    }

    public String fuelType() {
        return this.faker.resolve("vehicle.fuel_types");
    }

    public String carType() {
        return this.faker.resolve("vehicle.car_types");
    }

    public String engine() {
        return this.faker.resolve("vehicle.engine_sizes") + " " + this.faker.resolve("vehicle.cylinder_engine");
    }

    public List<String> carOptions() {
        return this.carOptions(5, 10);
    }

    public List<String> carOptions(int min, int max) {
        int optionSize;
        ArrayList<String> arr = new ArrayList<String>(optionSize);
        for (optionSize = this.faker.number().numberBetween(min, max); optionSize > 0; --optionSize) {
            arr.add(this.faker.resolve("vehicle.car_options"));
        }
        return arr;
    }

    public List<String> standardSpecs() {
        return this.standardSpecs(5, 10);
    }

    public List<String> standardSpecs(int min, int max) {
        int standardSpecsSize;
        ArrayList<String> arr = new ArrayList<String>(standardSpecsSize);
        for (standardSpecsSize = this.faker.number().numberBetween(min, max); standardSpecsSize > 0; --standardSpecsSize) {
            arr.add(this.faker.resolve("vehicle.standard_specs"));
        }
        return arr;
    }

    public String doors() {
        return this.faker.resolve("vehicle.doors");
    }

    public String licensePlate() {
        return this.faker.regexify(this.faker.bothify(this.faker.resolve("vehicle.license_plate")));
    }

    public String licensePlate(String stateAbbreviation) {
        if ("".equals(stateAbbreviation)) {
            return null;
        }
        String licensePlatesByState = this.faker.fakeValuesService().resolve("vehicle.license_plate_by_state." + stateAbbreviation, this, this.faker);
        return licensePlatesByState == null ? null : this.faker.regexify(this.faker.bothify(licensePlatesByState)).toUpperCase(Locale.ROOT);
    }
}

