/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import net.datafaker.Faker;

public class Weather {
    private static final int DEFAULT_MIN_TEMP_C = -30;
    private static final int DEFAULT_MAX_TEMP_C = 38;
    private static final int DEFAULT_MIN_TEMP_F = -22;
    private static final int DEFAULT_MAX_TEMP_F = 100;
    private final Faker faker;

    protected Weather(Faker faker) {
        this.faker = faker;
    }

    public String description() {
        return this.faker.resolve("weather.description");
    }

    public String temperatureCelsius() {
        return this.temperature(-30, 38, "weather.temperature.celsius");
    }

    public String temperatureFahrenheit() {
        return this.temperature(-22, 100, "weather.temperature.fahrenheit");
    }

    public String temperatureCelsius(int minTemperature, int maxTemperature) {
        return this.temperature(minTemperature, maxTemperature, "weather.temperature.celsius");
    }

    public String temperatureFahrenheit(int minTemperature, int maxTemperature) {
        return this.temperature(minTemperature, maxTemperature, "weather.temperature.fahrenheit");
    }

    private String temperature(int minTemperature, int maxTemperature, String degreeKey) {
        return this.faker.random().nextInt(minTemperature, maxTemperature) + this.faker.resolve(degreeKey);
    }
}

