/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.fileformats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.datafaker.FakeCollection;

public class Csv<T> {
    public static final char DEFAULT_QUOTE = '\"';
    public static final String DEFAULT_SEPARATOR = ",";
    private final FakeCollection<T> collection;
    private final String separator;
    private final char quote;
    private final boolean withHeader;
    private final List<CollectionColumn<T>> columns;
    private final int limit;

    Csv(FakeCollection<T> collection, String separator, char quote, boolean withHeader, List<CollectionColumn<T>> columns, int limit) {
        this.collection = collection;
        this.separator = separator;
        this.quote = quote;
        this.withHeader = withHeader;
        this.columns = columns;
        this.limit = limit == -1 && collection == null ? 10 : limit;
    }

    public String get() {
        if (this.columns == null) {
            throw new IllegalArgumentException("Length of headers should be equal to length of columns");
        }
        StringBuilder sb = new StringBuilder();
        if (this.withHeader) {
            this.addLine(sb, integer -> this.columns.get((int)integer).getName());
        }
        List<T> res = this.collection == null ? null : this.collection.get();
        int line = 0;
        while (line < (res == null ? this.limit : (this.limit != -1 ? Math.min(this.limit, res.size()) : res.size()))) {
            int rowNum = line++;
            this.addLine(sb, integer -> this.columns.get((int)integer).getValue(res == null || res.isEmpty() ? null : (Object)res.get(rowNum)));
        }
        return sb.toString();
    }

    private void addLine(StringBuilder result, Function<Integer, String> function) {
        for (int i = 0; i < this.columns.size(); ++i) {
            result.append(this.quote);
            String header = String.valueOf(function.apply(i));
            for (int j = 0; j < header.length(); ++j) {
                if (this.quote == header.charAt(j)) {
                    result.append(this.quote);
                }
                result.append(header.charAt(j));
            }
            result.append(this.quote);
            result.append(i == this.columns.size() - 1 ? System.lineSeparator() : this.separator);
        }
    }

    public static abstract class CsvBuilder {
        private String separator = ",";
        private char quote = (char)34;
        private int limit = -1;
        private boolean withHeader = true;

        public <T extends CsvBuilder> T header(boolean withHeader) {
            this.withHeader = withHeader;
            return (T)this;
        }

        public <T extends CsvBuilder> T separator(String separator) {
            this.separator = separator;
            return (T)this;
        }

        public <T extends CsvBuilder> T quote(char quote) {
            this.quote = quote;
            return (T)this;
        }

        public <T extends CsvBuilder> T limit(int limit) {
            this.limit = limit;
            return (T)this;
        }

        public String getSeparator() {
            return this.separator;
        }

        public char getQuote() {
            return this.quote;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean isWithHeader() {
            return this.withHeader;
        }

        public abstract Csv build();
    }

    public static class CsvCollectionBasedBuilder<T>
    extends CsvBuilder {
        protected FakeCollection<T> collection;
        protected Supplier<String>[] headers;
        protected Function<T, String>[] columnValues;

        CsvCollectionBasedBuilder<T> collection(FakeCollection<T> collection) {
            this.collection = collection;
            return this;
        }

        @SafeVarargs
        public final CsvCollectionBasedBuilder<T> headers(Supplier<String> ... headers) {
            this.headers = headers;
            return this;
        }

        @SafeVarargs
        public final CsvCollectionBasedBuilder<T> columns(Function<T, String> ... columns) {
            this.columnValues = columns;
            return this;
        }

        @SafeVarargs
        public final CsvCollectionBasedBuilder<T> columns(Supplier<String> ... columns) {
            this.columnValues = Stream.of(columns).map(c -> arg_0 -> CsvCollectionBasedBuilder.lambda$null$0((Supplier)c, arg_0)).collect(Collectors.toList()).toArray(new Function[0]);
            return this;
        }

        @Override
        public Csv<T> build() {
            if (this.headers != null && this.columnValues != null && this.headers.length != this.columnValues.length) {
                throw new IllegalArgumentException("Length of headers should be equal to length of columns");
            }
            ArrayList cols = this.columnValues == null ? Collections.emptyList() : new ArrayList(this.columnValues.length);
            for (int i = 0; i < (this.columnValues == null ? 0 : this.columnValues.length); ++i) {
                cols.add(CollectionColumn.of(this.headers == null ? null : this.headers[i], this.columnValues[i]));
            }
            return new Csv<T>(this.collection, this.getSeparator(), this.getQuote(), this.isWithHeader(), cols, this.getLimit());
        }

        private static /* synthetic */ String lambda$null$0(Supplier c, Object t) {
            return (String)c.get();
        }
    }

    public static class CsvColumnBasedBuilder<T, U extends CollectionColumn<T>>
    extends CsvBuilder {
        private List<U> columns = new ArrayList<U>();

        public final CsvColumnBasedBuilder<T, U> columns(List<U> columns) {
            this.columns = columns;
            return this;
        }

        @SafeVarargs
        public final CsvColumnBasedBuilder<T, U> columns(U ... columns) {
            this.columns = new ArrayList<U>(columns.length);
            this.columns.addAll(Arrays.asList(columns));
            return this;
        }

        @Override
        public Csv build() {
            return new Csv(null, this.getSeparator(), this.getQuote(), this.isWithHeader(), this.columns, this.getLimit());
        }
    }

    public static class CollectionColumn<T> {
        private final Supplier<String> name;
        private final Function<T, String> valueSupplier;

        private CollectionColumn(Supplier<String> name, Supplier<String> valueSupplier) {
            this.name = name;
            this.valueSupplier = t -> (String)valueSupplier.get();
        }

        private CollectionColumn(Supplier<String> name, Function<T, String> valueSupplier) {
            this.name = name;
            this.valueSupplier = valueSupplier;
        }

        public static <T> CollectionColumn<T> of(Supplier<String> name, Function<T, String> valueSupplier) {
            return new CollectionColumn<T>(name, valueSupplier);
        }

        public String getName() {
            return this.name.get();
        }

        public String getValue(T object) {
            return this.valueSupplier.apply(object);
        }
    }

    public static class Column
    extends CollectionColumn<String> {
        private Column(Supplier<String> name, Supplier<String> valueSupplier) {
            super(name, valueSupplier);
        }

        public static Column of(String name, Supplier<String> valueSupplier) {
            return new Column(() -> name, valueSupplier);
        }

        public static Column of(Supplier<String> name, Supplier<String> valueSupplier) {
            return new Column(name, valueSupplier);
        }
    }
}

