/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.fileformats;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.datafaker.FakeCollection;

public class Json {
    private static final Map<Character, String> ESCAPING_MAP = Json.createEscapeMap();
    private final Map<Supplier<String>, Supplier<Object>> map;

    public Json(Map<Supplier<String>, Supplier<Object>> map) {
        this.map = map;
    }

    public String generate() {
        return Json.generate(this.map);
    }

    private static String generate(Collection<Object> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        for (Object value : collection) {
            if (i > 0) {
                sb.append(", ");
            }
            ++i;
            Json.value2String(value, sb);
        }
        sb.append("]");
        return sb.toString();
    }

    private static void value2String(Object value, StringBuilder sb) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof BigInteger || value instanceof Boolean || value instanceof BigDecimal && ((BigDecimal)value).remainder(BigDecimal.ONE).doubleValue() == 0.0) {
            sb.append(value);
        } else if (value instanceof Map) {
            sb.append(Json.generate((Map)value));
        } else if (value instanceof Collection) {
            sb.append(Json.generate((Collection)value));
        } else if (value.getClass().isArray()) {
            sb.append(Json.generate(Arrays.asList((Object[])value)));
        } else if (value instanceof Json) {
            sb.append(((Json)value).generate());
        } else {
            boolean toWrap;
            String val = String.valueOf(value);
            boolean bl = toWrap = !val.startsWith("#{json");
            if (toWrap) {
                sb.append("\"");
            }
            for (char c : String.valueOf(value).toCharArray()) {
                sb.append(ESCAPING_MAP.getOrDefault(Character.valueOf(c), c + ""));
            }
            if (toWrap) {
                sb.append("\"");
            }
        }
    }

    private static String generate(Map<Supplier<String>, Supplier<Object>> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<Supplier<String>, Supplier<Object>> entry : map.entrySet()) {
            String key = entry.getKey().get();
            if (!keys.add(key)) continue;
            if (keys.size() > 1) {
                sb.append(", ");
            }
            sb.append("\"");
            for (char c : key.toCharArray()) {
                sb.append(ESCAPING_MAP.getOrDefault(Character.valueOf(c), c + ""));
            }
            sb.append("\": ");
            Object value = entry.getValue().get();
            Json.value2String(value, sb);
        }
        sb.append("}");
        return sb.toString();
    }

    private static Map<Character, String> createEscapeMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('\\'), "\\\\");
        map.put(Character.valueOf('\"'), "\\\"");
        map.put(Character.valueOf('\b'), "\\b");
        map.put(Character.valueOf('\f'), "\\f");
        map.put(Character.valueOf('\n'), "\\n");
        map.put(Character.valueOf('\r'), "\\r");
        map.put(Character.valueOf('\t'), "\\t");
        map.put(Character.valueOf('/'), "\\/");
        map.put(Character.valueOf('\u0000'), "\\u0000");
        map.put(Character.valueOf('\u0001'), "\\u0001");
        map.put(Character.valueOf('\u0002'), "\\u0002");
        map.put(Character.valueOf('\u0003'), "\\u0003");
        map.put(Character.valueOf('\u0004'), "\\u0004");
        map.put(Character.valueOf('\u0005'), "\\u0005");
        map.put(Character.valueOf('\u0006'), "\\u0006");
        map.put(Character.valueOf('\u0007'), "\\u0007");
        map.put(Character.valueOf('\u000b'), "\\u000B");
        map.put(Character.valueOf('\u000e'), "\\u000E");
        map.put(Character.valueOf('\u000f'), "\\u000F");
        map.put(Character.valueOf('\u0010'), "\\u0010");
        map.put(Character.valueOf('\u0011'), "\\u0011");
        map.put(Character.valueOf('\u0012'), "\\u0012");
        map.put(Character.valueOf('\u0013'), "\\u0013");
        map.put(Character.valueOf('\u0014'), "\\u0014");
        map.put(Character.valueOf('\u0015'), "\\u0015");
        map.put(Character.valueOf('\u0016'), "\\u0016");
        map.put(Character.valueOf('\u0017'), "\\u0017");
        map.put(Character.valueOf('\u0018'), "\\u0018");
        map.put(Character.valueOf('\u0019'), "\\u0019");
        map.put(Character.valueOf('\u001a'), "\\u001A");
        map.put(Character.valueOf('\u001b'), "\\u001B");
        map.put(Character.valueOf('\u001c'), "\\u001C");
        map.put(Character.valueOf('\u001d'), "\\u001D");
        map.put(Character.valueOf('\u001e'), "\\u001E");
        map.put(Character.valueOf('\u001f'), "\\u001F");
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        return this.map == null ? null : this.generate();
    }

    public static class JsonForFakeCollection<T> {
        private final Map<Function<T, String>, Function<T, Object>> map;
        private final FakeCollection<T> collection;

        public JsonForFakeCollection(FakeCollection<T> collection, Map<Function<T, String>, Function<T, Object>> map) {
            this.map = map;
            this.collection = collection;
        }

        public String generate() {
            StringBuilder sb = new StringBuilder();
            List<T> col = this.collection.get();
            if (col == null) {
                return null;
            }
            if (col.isEmpty()) {
                return "[]";
            }
            sb.append("[");
            for (int i = 0; i < col.size(); ++i) {
                sb.append(this.generate(col.get(i), this.map));
                if (i >= col.size() - 1) continue;
                sb.append(",").append(System.lineSeparator());
            }
            sb.append("]");
            return sb.toString();
        }

        private String generate(T record, Map<Function<T, String>, Function<T, Object>> map) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            HashSet<String> keys = new HashSet<String>();
            for (Map.Entry<Function<T, String>, Function<T, Object>> entry : map.entrySet()) {
                String key = entry.getKey().apply(record);
                if (!keys.add(key)) continue;
                if (keys.size() > 1) {
                    sb.append(", ");
                }
                sb.append("\"");
                for (char c : key.toCharArray()) {
                    sb.append(ESCAPING_MAP.getOrDefault(Character.valueOf(c), c + ""));
                }
                sb.append("\": ");
                Object value = entry.getValue().apply(record);
                if (value instanceof JsonForFakeCollection) {
                    sb.append(((JsonForFakeCollection)value).generate());
                    continue;
                }
                if (value instanceof Collection) {
                    sb.append(Json.generate((Collection)value));
                    continue;
                }
                if (value.getClass().isArray()) {
                    sb.append(Json.generate(Arrays.asList((Object[])value)));
                    continue;
                }
                if (value instanceof Json) {
                    sb.append(((Json)value).generate());
                    continue;
                }
                this.value2String(record, value, sb);
            }
            sb.append("}");
            return sb.toString();
        }

        private void value2String(T record, Object value, StringBuilder sb) {
            if (value == null) {
                sb.append("null");
            } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof BigInteger || value instanceof Boolean || value instanceof BigDecimal && ((BigDecimal)value).remainder(BigDecimal.ONE).doubleValue() == 0.0) {
                sb.append(value);
            } else if (value instanceof Map) {
                sb.append(this.generate(record, (Map)value));
            } else {
                sb.append("\"");
                for (char c : String.valueOf(value).toCharArray()) {
                    sb.append(ESCAPING_MAP.getOrDefault(Character.valueOf(c), c + ""));
                }
                sb.append("\"");
            }
        }
    }

    public static class JsonFromCollectionBuilder<T> {
        private final Map<Function<T, String>, Function<T, Object>> map = new LinkedHashMap<Function<T, String>, Function<T, Object>>();
        private final FakeCollection<T> collection;

        public JsonFromCollectionBuilder(FakeCollection<T> collection) {
            this.collection = collection;
        }

        public JsonFromCollectionBuilder<T> set(String key, Function<T, Object> value) {
            this.map.put(t -> key, value);
            return this;
        }

        public JsonFromCollectionBuilder<T> set(Function<T, String> key, Function<T, Object> value) {
            this.map.put(key, value);
            return this;
        }

        public JsonFromCollectionBuilder<T> set(String key, Json value) {
            this.map.put(t -> key, t -> value);
            return this;
        }

        public JsonFromCollectionBuilder<T> set(String key, JsonForFakeCollection value) {
            this.map.put(t -> key, t -> value);
            return this;
        }

        public JsonForFakeCollection<T> build() {
            return new JsonForFakeCollection<T>(this.collection, this.map);
        }
    }

    public static class JsonBuilder {
        private final Map<Supplier<String>, Supplier<Object>> map = new LinkedHashMap<Supplier<String>, Supplier<Object>>();

        public JsonBuilder set(String key, Supplier<Object> value) {
            this.map.put(() -> key, value);
            return this;
        }

        public JsonBuilder set(Supplier<String> key, Supplier<Object> value) {
            this.map.put(key, value);
            return this;
        }

        public Json build() {
            return new Json(this.map);
        }
    }
}

