/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.fileformats;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Xml {
    private static final Map<Character, String> ESCAPING_MAP = Xml.createEscapeMap();
    private static final int INDENTATION_STEP = 4;
    private final XmlNode xmlNode;
    private int tagIndex = 0;

    public Xml(XmlNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    public String generate() {
        return this.generate(false);
    }

    public String generate(boolean pretty) {
        return this.generate(this.xmlNode, new StringBuilder(), pretty);
    }

    private String generate(XmlNode xmlNode, StringBuilder sb, boolean pretty) {
        String tag = xmlNode.tagName;
        if (pretty && this.tagIndex > 0) {
            sb.append(System.lineSeparator()).append(this.offset(this.tagIndex));
        }
        sb.append("<").append(tag);
        for (Map.Entry entry : xmlNode.attributes.entrySet()) {
            sb.append(" ").append((String)entry.getKey()).append("=\"").append(this.escape((String)entry.getValue())).append("\"");
        }
        if (xmlNode.children.isEmpty()) {
            if (xmlNode.value != null) {
                sb.append(">");
                sb.append(this.escape(xmlNode.value));
                sb.append("</").append(tag).append(">");
            } else {
                sb.append("/>");
            }
        } else {
            sb.append(">");
            ++this.tagIndex;
            for (XmlNode xmlNodeElem : xmlNode.children) {
                this.generate(xmlNodeElem, sb, pretty);
            }
            --this.tagIndex;
            if (pretty) {
                sb.append(System.lineSeparator()).append(this.offset(this.tagIndex));
            }
            sb.append("</").append(tag).append(">");
        }
        return sb.toString();
    }

    private String escape(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append(ESCAPING_MAP.getOrDefault(Character.valueOf(c), c + ""));
        }
        return sb.toString();
    }

    private String offset(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length * 4; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static Map<Character, String> createEscapeMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('<'), "&lt;");
        map.put(Character.valueOf('>'), "&gt;");
        map.put(Character.valueOf('&'), "&amp;");
        map.put(Character.valueOf('\''), "&apos;");
        map.put(Character.valueOf('\"'), "&quot;");
        return Collections.unmodifiableMap(map);
    }

    public static class XmlNode {
        private final String tagName;
        private final Map<String, String> attributes;
        private final Collection<XmlNode> children;
        private final String value;

        public XmlNode(String tagName, Collection<XmlNode> children) {
            this.tagName = tagName;
            this.attributes = Collections.emptyMap();
            this.children = children;
            this.value = null;
        }

        public XmlNode(String tagName, Map<String, String> attributes, Collection<XmlNode> children) {
            this.tagName = tagName;
            this.attributes = attributes;
            this.children = children;
            this.value = null;
        }

        public XmlNode(String tagName, Map<String, String> attributes, String value) {
            this.tagName = tagName;
            this.attributes = attributes;
            this.children = Collections.emptyList();
            this.value = value;
        }

        public XmlNode(String tagName, String value) {
            this.tagName = tagName;
            this.attributes = Collections.emptyMap();
            this.children = Collections.emptyList();
            this.value = value;
        }
    }
}

