/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.fileformats;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;

public class Yaml {
    private static final String INDENTATION = "  ";
    private final Map<Supplier<String>, Supplier<Object>> map;

    public Yaml(Map<Supplier<String>, Supplier<Object>> map) {
        this.map = map;
    }

    public String generate() {
        return this.generate(new StringBuilder(), this.map, "");
    }

    private String generate(StringBuilder sb, Map<Supplier<String>, Supplier<Object>> map, String offset) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<Supplier<String>, Supplier<Object>> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey().get()).trim();
            if (!keys.add(key)) continue;
            Object value = entry.getValue().get();
            sb.append(offset).append(key).append(":");
            if (value instanceof Map) {
                sb.append(System.lineSeparator());
                this.value2String(value, sb, offset + INDENTATION);
            } else {
                this.value2String(value, sb, offset);
            }
            if (sb.lastIndexOf(System.lineSeparator()) == sb.length() - System.lineSeparator().length()) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private void addCollection(StringBuilder sb, Collection<Object> collection, String offset) {
        for (Object value : collection) {
            this.value2String(value, sb, offset + "-");
            sb.append(System.lineSeparator());
        }
    }

    private void value2String(Object value, StringBuilder sb, String offset) {
        if (value instanceof Map) {
            this.generate(sb, (Map)value, offset);
        } else if (value instanceof Collection) {
            sb.append(System.lineSeparator());
            offset = offset + INDENTATION;
            this.addCollection(sb, (Collection)value, offset);
        } else if (value != null && value.getClass().isArray()) {
            sb.append(System.lineSeparator());
            offset = offset + INDENTATION;
            this.addCollection(sb, Arrays.asList((Object[])value), offset);
        } else {
            if (sb.charAt(sb.length() - 1) != ':') {
                sb.append(offset);
            }
            sb.append(" ").append(String.valueOf(value).trim());
        }
    }
}

