/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.util.Arrays;
import java.util.List;
import net.datafaker.Faker;

public class EsMXIdNumber {
    private final String[] consonant = new String[]{"B", "C", "C", "D", "F", "G", "H", "J", "K", "L", "L", "M", "N", "N", "P", "Q", "R", "S", "T", "V", "W", "X", "Y", "Z"};
    private final String[] vowel = new String[]{"A", "E", "I", "O", "U"};
    private final String[] states = new String[]{"AG", "BC", "BS", "CM", "CS", "CH", "CO", "CL", "DF", "DG", "GT", "GR", "HG", "JA", "EM", "MI", "MO", "NA", "NL", "OA", "PU", "QT", "QR", "SL", "SI", "SO", "TB", "TM", "TL", "VE", "YU", "ZA", "NE"};

    public String get(Faker faker) {
        String sex = (new String[]{"H", "M"})[faker.random().nextInt(2)];
        String birthDay = this.getBirthday(faker);
        String state = this.states[faker.random().nextInt(33)];
        String c1 = this.consonant[faker.random().nextInt(24)];
        String c2 = this.consonant[faker.random().nextInt(24)];
        String c3 = this.consonant[faker.random().nextInt(24)];
        String v1 = this.vowel[faker.random().nextInt(5)];
        String v2 = this.vowel[faker.random().nextInt(5)];
        String v3 = this.vowel[faker.random().nextInt(5)];
        String v4 = this.vowel[faker.random().nextInt(5)];
        String ranNum = Integer.parseInt(birthDay.substring(0, 4)) <= 1999 ? "0" : this.consonant[faker.random().nextInt(24)];
        String ssn = c1 + v1 + c2 + c3 + birthDay.substring(2, 8) + sex + state + v2 + v3 + v4 + ranNum;
        ssn = ssn + this.getChecksum(ssn);
        return ssn;
    }

    public String getWrong(Faker faker) {
        String[] cha = new String[]{"HEFA560427MVZRRL04", "DKEM193827HDQWEF05", "KAKS142444HNSSFAW6", "KSDF414424HNSDFAW6", "AKDF414424MSDSFAW6", "ADKF144424MNSDFCD6", "MYDF144424MDNFAW37", "AKKS414424MDAFDFW6", "WKDF144244HSDCNFA2", "AKSK414244HSDATT56", "QWDF414424HNSDVAW4", "AKDF144424MDEFVFA1"};
        return cha[faker.random().nextInt(12)];
    }

    private String getBirthday(Faker f) {
        int year = f.random().nextInt(1900, 2021);
        int month = f.random().nextInt(1, 12);
        int day = this.validDay(year, month, f);
        return String.valueOf(year * 10000 + month * 100 + day);
    }

    private int validDay(int year, int month, Faker f) {
        List<Integer> bigMonths = Arrays.asList(1, 3, 5, 7, 8, 10, 12);
        if (month == 2) {
            if (year % 4 == 0) {
                return f.random().nextInt(1, 29);
            }
            return f.random().nextInt(1, 28);
        }
        if (bigMonths.contains(month)) {
            return f.random().nextInt(1, 31);
        }
        return f.random().nextInt(1, 30);
    }

    private int getChecksum(String str) {
        int sum = 0;
        int v = str.length() + 1;
        for (int i = 0; i < str.length(); ++i) {
            int number = str.charAt(i) < '9' ? str.charAt(i) - 48 : str.charAt(i) - 65 + 10;
            sum += number * v--;
        }
        return (sum = Math.abs(sum % 10 - 10)) == 10 ? 0 : sum;
    }
}

