/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.util.Optional;
import net.datafaker.Faker;

public class PeselNumber {
    public static final int PESEL_LENGTH = 11;
    private final Faker faker;

    public PeselNumber(Faker faker) {
        this.faker = faker;
    }

    public String get(LocalDate birthDate, Gender gender) {
        return this.getInternal(birthDate, Optional.ofNullable(gender).orElse(Gender.ANY));
    }

    private String getInternal(LocalDate birthDate, Gender gender) {
        int[] digits = new int[10];
        digits[0] = birthDate.getYear() / 10 % 10;
        digits[1] = birthDate.getYear() % 10;
        int monthEncoded = this.getMonthEncoded(birthDate.getYear(), birthDate.getMonthValue());
        digits[2] = monthEncoded / 10;
        digits[3] = monthEncoded % 10;
        digits[4] = birthDate.getDayOfMonth() / 10;
        digits[5] = birthDate.getDayOfMonth() % 10;
        digits[6] = this.randomDigit();
        digits[7] = this.randomDigit();
        digits[8] = this.randomDigit();
        digits[9] = this.getGenderDigit(gender);
        int controlDigit = this.getControlDigit(digits);
        StringBuilder peselSb = new StringBuilder(11);
        for (int digit : digits) {
            peselSb.append(digit);
        }
        peselSb.append(controlDigit);
        return peselSb.toString();
    }

    private int randomDigit() {
        return this.faker.random().nextInt(10);
    }

    private int getControlDigit(int[] digits) {
        int sum = digits[0] + digits[4] + digits[8] + (digits[1] + digits[5] + digits[9]) * 3 + (digits[2] + digits[6]) * 7 + (digits[3] + digits[7]) * 9;
        return (10 - sum % 10) % 10;
    }

    private int getGenderDigit(Gender gender) {
        switch (gender) {
            case FEMALE: {
                return this.faker.random().nextInt(5) * 2;
            }
            case MALE: {
                return this.faker.random().nextInt(5) * 2 + 1;
            }
        }
        return this.randomDigit();
    }

    private int getMonthEncoded(int year, int month) {
        int monthModifier;
        if (year < 1800) {
            throw new IllegalArgumentException("Year is before 1800");
        }
        if (year < 1900) {
            monthModifier = 80;
        } else if (year < 2000) {
            monthModifier = 0;
        } else if (year < 2100) {
            monthModifier = 20;
        } else if (year < 2200) {
            monthModifier = 40;
        } else if (year < 2300) {
            monthModifier = 60;
        } else {
            throw new IllegalArgumentException("Year is after 2300");
        }
        return month + monthModifier;
    }

    public static enum Gender {
        MALE,
        FEMALE,
        ANY;

    }
}

