/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import net.datafaker.Faker;

public class PtNifIdNumber {
    private static final Character[] validFirstDigits = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('8')};
    private static final String[] validFirstDoubleDigits = new String[]{"45", "70", "71", "72", "74", "75", "77", "79", "90", "91", "98", "99"};

    public String getInvalid(Faker faker) {
        String digits = faker.number().digits(8);
        int digitSum = this.calculateDigitSum(digits);
        return digits + (digitSum + 5);
    }

    public String getValid(Faker faker) {
        String digits;
        int i;
        if (faker.random().nextBoolean()) {
            i = faker.number().numberBetween(0, validFirstDigits.length - 1);
            char firstDigit = validFirstDigits[i].charValue();
            digits = firstDigit + faker.number().digits(7);
        } else {
            i = faker.number().numberBetween(0, validFirstDoubleDigits.length - 1);
            String firstDoubleDigit = validFirstDoubleDigits[i];
            digits = firstDoubleDigit + faker.number().digits(6);
        }
        int digitSum = this.calculateDigitSum(digits);
        return digits + digitSum;
    }

    private int calculateDigitSum(String numbers) {
        int val;
        int checkSum = 0;
        for (int i = 1; i <= numbers.length(); ++i) {
            int digit = Character.getNumericValue(numbers.charAt(i - 1));
            checkSum += (10 - i) * digit;
        }
        checkSum = (checkSum -= (val = checkSum / 11 * 11)) == 0 || checkSum == 1 ? 0 : 11 - checkSum;
        return checkSum;
    }
}

