/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.datafaker.Faker;

public class SvSEIdNumber {
    private static final String[] validPatterns = new String[]{"######-####", "######+####"};

    public String getValidSsn(Faker f) {
        String candidate = "";
        while (!this.validSwedishSsn(candidate)) {
            String pattern = this.getPattern(f);
            candidate = f.numerify(pattern);
        }
        return candidate;
    }

    public String getInvalidSsn(Faker f) {
        String candidate = "121212-1212";
        while (this.validSwedishSsn(candidate)) {
            String pattern = this.getPattern(f);
            candidate = f.numerify(pattern);
        }
        return candidate;
    }

    private String getPattern(Faker faker) {
        return validPatterns[faker.random().nextInt(2)];
    }

    boolean validSwedishSsn(String ssn) {
        if (ssn.length() != 11) {
            return false;
        }
        try {
            if (this.parseDate(ssn)) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        int calculatedChecksum = this.calculateChecksum(ssn);
        int checksum = Integer.parseInt(ssn.substring(10, 11));
        return checksum == calculatedChecksum;
    }

    private boolean parseDate(String ssn) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        String dateString = ssn.substring(0, 6);
        Date date = sdf.parse(dateString);
        String reversed = sdf.format(date);
        return !reversed.equals(dateString);
    }

    private int calculateChecksum(String number) {
        String dateString = number.substring(0, 6);
        String birthNumber = number.substring(7, 10);
        String calculatedNumber = this.calculateDigits(dateString + birthNumber);
        int sum = this.calculateDigitSum(calculatedNumber);
        int lastDigit = sum % 10;
        int difference = 10 - lastDigit;
        return difference % 10;
    }

    private String calculateDigits(String numbers) {
        StringBuilder calculatedNumbers = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            int n = Integer.parseInt(numbers.substring(i, i + 1));
            int res = i % 2 == 0 ? n << 1 : n;
            calculatedNumbers.append(res);
        }
        return calculatedNumbers.toString();
    }

    private int calculateDigitSum(String numbers) {
        int sum = 0;
        for (int i = 0; i < numbers.length(); ++i) {
            int n = Integer.parseInt(numbers.substring(i, i + 1));
            sum += n;
        }
        return sum;
    }
}

