/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers.pt.br;

import net.datafaker.Faker;
import net.datafaker.idnumbers.pt.br.DocumentFormatterUtil;

public final class IdNumberGeneratorPtBrUtil {
    private IdNumberGeneratorPtBrUtil() {
    }

    public static String cnpj(Faker faker, boolean formatted, boolean valid, boolean multiBranch) {
        String result;
        String cnpj;
        if (valid) {
            StringBuilder partial = new StringBuilder();
            for (int i = 0; i < 8; ++i) {
                partial.append(faker.random().nextInt(9));
            }
            if (multiBranch) {
                partial.append(IdNumberGeneratorPtBrUtil.leftPad('0', 4, String.valueOf(faker.random().nextInt(1, 9999))));
            } else {
                partial.append("0001");
            }
            cnpj = partial.toString();
            int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight(cnpj.substring(4, 12), 9) + IdNumberGeneratorPtBrUtil.calculateWeight(cnpj.substring(0, 4), 5));
            int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight(cnpj.substring(5, 12), 9) + IdNumberGeneratorPtBrUtil.calculateWeight(cnpj.substring(0, 5), 6));
            cnpj = cnpj + d1 + d2;
        } else {
            cnpj = String.valueOf((long)faker.random().nextInt(1000000000) + (long)(faker.random().nextInt(90) + 10) * 1000000000000L);
        }
        String string = result = formatted ? DocumentFormatterUtil.cnpj(cnpj) : cnpj;
        if (IdNumberGeneratorPtBrUtil.isCNPJValid(result) != valid) {
            result = IdNumberGeneratorPtBrUtil.cnpj(faker, formatted, valid, multiBranch);
        }
        return result;
    }

    public static String cpf(Faker faker, boolean formatted, boolean valid) {
        String result;
        String cpf;
        if (valid) {
            StringBuilder partial = new StringBuilder();
            for (int i = 0; i < 9; ++i) {
                partial.append(faker.random().nextInt(9));
            }
            cpf = partial.toString();
            int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight(cpf, 10));
            int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight(cpf, 11));
            cpf = cpf + d1 + d2;
        } else {
            cpf = String.valueOf((long)faker.random().nextInt(1000000000) + (long)(faker.random().nextInt(90) + 10) * 1000000000L);
        }
        String string = result = formatted ? DocumentFormatterUtil.cpf(cpf) : cpf;
        if (IdNumberGeneratorPtBrUtil.isCPFValid(result) != valid) {
            result = IdNumberGeneratorPtBrUtil.cpf(faker, formatted, valid);
        }
        return result;
    }

    public static Boolean isCNPJValid(String cnpj) {
        String cnpjUnmask = DocumentFormatterUtil.unmask(cnpj);
        String cnpjPartial = cnpjUnmask.substring(0, 12);
        int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight(cnpjPartial.substring(4, 12), 9) + IdNumberGeneratorPtBrUtil.calculateWeight(cnpjPartial.substring(0, 4), 5));
        int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight(cnpjPartial.substring(5, 12), 9) + IdNumberGeneratorPtBrUtil.calculateWeight(cnpjPartial.substring(0, 5), 6));
        String anObject = cnpjPartial + d1 + d2;
        return cnpjUnmask.equals(anObject);
    }

    public static Boolean isCPFValid(String cpf) {
        String cpfUnmask = DocumentFormatterUtil.unmask(cpf);
        String cpfPartial = cpfUnmask.substring(0, 9);
        int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight(cpfPartial, 10));
        int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight(cpfPartial, 11));
        return cpfUnmask.equals(cpfPartial + d1 + d2);
    }

    public static int calculateWeight(String num, int weight) {
        int sum = 0;
        int weightAux = weight;
        for (int index = 0; index < num.length(); ++index) {
            sum += Integer.parseInt(num.substring(index, index + 1)) * weightAux--;
        }
        return sum;
    }

    public static int digit(int verifyingDigit) {
        if (verifyingDigit % 11 == 0 || verifyingDigit % 11 == 1) {
            return 0;
        }
        return 11 - verifyingDigit % 11;
    }

    private static String leftPad(char pad, int length, String string) {
        StringBuilder appender = new StringBuilder();
        for (int i = 0; i < length - string.length(); ++i) {
            appender.append(pad);
        }
        return appender.append(string).toString();
    }
}

