/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import com.github.javafaker.shaded.snakeyaml.Yaml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.datafaker.service.FakeValuesInterface;

public class FakeValues
implements FakeValuesInterface {
    private static final Logger LOG = Logger.getLogger("faker");
    private final Locale locale;
    private final String filename;
    private final String path;
    private final Path filePath;
    private Map<String, Object> values;

    FakeValues(Locale locale) {
        this(locale, FakeValues.getFilename(locale), FakeValues.getFilename(locale), null);
    }

    FakeValues(Locale locale, Path filePath) {
        this(locale, FakeValues.getFilename(locale), null, filePath);
    }

    FakeValues(Locale locale, String filename, String path) {
        this(locale, filename, path, null);
    }

    FakeValues(Locale locale, String filename, String path, Path filePath) {
        this.locale = locale;
        this.filename = filename;
        this.filePath = filePath;
        if (path == null) {
            this.values = this.loadValues();
            this.path = this.values == null || this.values.isEmpty() ? null : this.values.keySet().iterator().next();
        } else {
            this.path = path;
        }
    }

    private static String getFilename(Locale locale) {
        String lang = FakeValues.language(locale);
        if ("".equals(locale.getCountry())) {
            return lang;
        }
        return lang + "-" + locale.getCountry();
    }

    private static String language(Locale l) {
        if (l.getLanguage().equals("iw")) {
            return "he";
        }
        return l.getLanguage();
    }

    @Override
    public Map<String, Object> get(String key) {
        if (this.values == null) {
            this.values = this.loadValues();
        }
        return this.values == null ? null : (Map)this.values.get(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> loadFromFilePath() {
        if (this.filePath == null) return null;
        if (!Files.exists(this.filePath, new LinkOption[0])) return null;
        if (Files.isDirectory(this.filePath, new LinkOption[0])) return null;
        if (!Files.isReadable(this.filePath)) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(this.filePath, new OpenOption[0]);){
            Map<String, Object> map = this.readFromStream(stream);
            return map;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception: ", e);
            return null;
        }
    }

    private Map<String, Object> loadValues() {
        Map<String, Object> result = this.loadFromFilePath();
        if (result != null) {
            return result;
        }
        String pathWithLocaleAndFilename = "/" + this.locale.getLanguage() + "/" + this.filename;
        String pathWithFilename = "/" + this.filename + ".yml";
        String pathWithLocale = "/" + this.locale.getLanguage() + ".yml";
        List<String> paths = Arrays.asList(pathWithLocaleAndFilename, pathWithFilename, pathWithLocale);
        for (String path : paths) {
            block31: {
                try (InputStream stream = this.getClass().getResourceAsStream(path);){
                    if (stream != null) {
                        result = this.readFromStream(stream);
                        break block31;
                    }
                    try (InputStream stream2 = this.getClass().getClassLoader().getResourceAsStream(path);){
                        result = this.readFromStream(stream2);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Exception: ", e);
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Exception: ", e);
                }
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Map<String, Object> readFromStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        Map valuesMap = new Yaml().loadAs(stream, Map.class);
        Map localeBased = (Map)valuesMap.get(this.locale.getLanguage());
        if (localeBased == null) {
            localeBased = (Map)valuesMap.get(this.filename);
        }
        return (Map)localeBased.get("faker");
    }

    boolean supportsPath(String path) {
        return this.path.equals(path);
    }

    String getPath() {
        return this.path;
    }

    Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeValues that = (FakeValues)o;
        return Objects.equals(this.locale, that.locale) && Objects.equals(this.filename, that.filename) && Objects.equals(this.path, that.path) && Objects.equals(this.filePath, that.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.filename, this.path, this.filePath);
    }
}

