/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.datafaker.service.FakeValues;
import net.datafaker.service.FakeValuesInterface;
import net.datafaker.service.files.EnFile;

public class FakeValuesGrouping
implements FakeValuesInterface {
    private static final FakeValuesGrouping ENGLISH_FAKE_VALUE_GROUPING = new FakeValuesGrouping();
    private final Map<String, Collection<FakeValuesInterface>> fakeValues = new HashMap<String, Collection<FakeValuesInterface>>();

    public void add(FakeValuesInterface fakeValue) {
        if (fakeValue instanceof FakeValues) {
            this.fakeValues.computeIfAbsent(((FakeValues)fakeValue).getPath(), key -> new HashSet()).add(fakeValue);
        } else if (fakeValue instanceof FakeValuesGrouping) {
            this.fakeValues.putAll(((FakeValuesGrouping)fakeValue).fakeValues);
        } else {
            throw new RuntimeException(this.fakeValues.getClass() + " not supported (please raise an issue)");
        }
    }

    public Map get(String key) {
        Map<String, Object> result = null;
        for (FakeValuesInterface fakeValues : (Collection)this.fakeValues.getOrDefault(key, Collections.emptyList())) {
            if (result != null) {
                Map<String, Object> newResult = fakeValues.get(key);
                result.putAll(newResult);
                continue;
            }
            result = fakeValues.get(key);
        }
        return result;
    }

    public static FakeValuesGrouping getEnglishFakeValueGrouping() {
        return ENGLISH_FAKE_VALUE_GROUPING;
    }

    static {
        for (EnFile file : EnFile.getFiles()) {
            ENGLISH_FAKE_VALUE_GROUPING.add(new FakeValues(Locale.ENGLISH, file.getFile(), file.getPath()));
        }
    }
}

