/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import com.mifmif.common.regex.Generex;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.datafaker.Faker;
import net.datafaker.fileformats.Csv;
import net.datafaker.fileformats.Format;
import net.datafaker.fileformats.Json;
import net.datafaker.service.FakeValues;
import net.datafaker.service.FakeValuesGrouping;
import net.datafaker.service.FakeValuesInterface;
import net.datafaker.service.RandomService;

public class FakeValuesService {
    private static final Pattern LOCALE = Pattern.compile("[-_]");
    private static final String DIGITS = "0123456789";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Logger LOG = Logger.getLogger("faker");
    private static final Map<Locale, FakeValuesInterface> FAKE_VALUES_CACHE = new HashMap<Locale, FakeValuesInterface>();
    private final Map<Locale, FakeValuesInterface> fakeValuesInterfaceMap = new HashMap<Locale, FakeValuesInterface>();
    private final RandomService randomService;
    private final List<Locale> localesChain;
    private final Map<Class<?>, Map<String, Collection<Method>>> class2methodsCache = new IdentityHashMap();
    private final Map<Class<?>, Constructor<?>> class2constructorCache = new IdentityHashMap();
    private final Map<String, Generex> expression2generex = new WeakHashMap<String, Generex>();
    private final Map<String, String> key2Expression = new WeakHashMap<String, String>();
    private final Map<String, String[]> args2splittedArgs = new WeakHashMap<String, String[]>();
    private final Map<String, String[]> key2splittedKey = new WeakHashMap<String, String[]>();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new IdentityHashMap();

    public FakeValuesService(Locale locale, RandomService randomService) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is required");
        }
        this.randomService = randomService;
        locale = this.normalizeLocale(locale);
        this.localesChain = this.localeChain(locale);
        for (Locale l : this.localesChain) {
            this.fakeValuesInterfaceMap.computeIfAbsent(l, this::getCachedFakeValue);
        }
    }

    private FakeValuesInterface getCachedFakeValue(Locale locale) {
        if (Locale.ENGLISH.equals(locale)) {
            return FakeValuesGrouping.getEnglishFakeValueGrouping();
        }
        return FAKE_VALUES_CACHE.computeIfAbsent(locale, FakeValues::new);
    }

    public void addPath(Locale locale, Path path) {
        Objects.requireNonNull(locale);
        if (path == null || Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            throw new IllegalArgumentException("Path should be an existing readable file");
        }
        FakeValues fakeValues = new FakeValues(locale, path);
        FakeValuesInterface existingFakeValues = this.fakeValuesInterfaceMap.get(locale);
        if (existingFakeValues == null) {
            this.fakeValuesInterfaceMap.putIfAbsent(locale, fakeValues);
        } else {
            FakeValuesGrouping fakeValuesGrouping = new FakeValuesGrouping();
            fakeValuesGrouping.add(existingFakeValues);
            fakeValuesGrouping.add(fakeValues);
            this.fakeValuesInterfaceMap.put(locale, fakeValuesGrouping);
        }
    }

    protected List<Locale> localeChain(Locale from) {
        if (Locale.ENGLISH.equals(from)) {
            return Collections.singletonList(Locale.ENGLISH);
        }
        Locale normalized = this.normalizeLocale(from);
        ArrayList<Locale> chain = new ArrayList<Locale>(3);
        chain.add(normalized);
        if (!"".equals(normalized.getCountry()) && !Locale.ENGLISH.getLanguage().equals(normalized.getLanguage())) {
            chain.add(new Locale(normalized.getLanguage()));
        }
        chain.add(Locale.ENGLISH);
        return chain;
    }

    private Locale normalizeLocale(Locale locale) {
        String[] parts = LOCALE.split(locale.toString());
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        return new Locale(parts[0], parts[1]);
    }

    public List<Locale> getLocalesChain() {
        return this.localesChain;
    }

    public Object fetch(String key) {
        ArrayList valuesArray = null;
        Object o = this.fetchObject(key);
        if (o instanceof ArrayList) {
            valuesArray = (ArrayList)o;
        }
        return valuesArray == null || valuesArray.isEmpty() ? null : valuesArray.get(this.randomService.nextInt(valuesArray.size()));
    }

    public String fetchString(String key) {
        return (String)this.fetch(key);
    }

    public String safeFetch(String key, String defaultIfNull) {
        Object o = this.fetchObject(key);
        if (o == null) {
            return defaultIfNull;
        }
        if (o instanceof List) {
            List values = (List)o;
            if (values.size() == 0) {
                return defaultIfNull;
            }
            return (String)values.get(this.randomService.nextInt(values.size()));
        }
        if (this.isSlashDelimitedRegex(o.toString())) {
            return String.format("#{regexify '%s'}", this.trimRegexSlashes(o.toString()));
        }
        return (String)o;
    }

    public Object fetchObject(String key) {
        String[] path = this.split(key);
        Object result = null;
        for (Locale locale : this.localesChain) {
            Object currentValue = this.fakeValuesInterfaceMap.get(locale);
            for (int p = 0; currentValue != null && p < path.length; ++p) {
                String currentPath = path[p];
                currentValue = currentValue instanceof Map ? ((Map)currentValue).get(currentPath) : currentValue.get(currentPath);
            }
            result = currentValue;
            if (result == null) continue;
            break;
        }
        return result;
    }

    private String[] split(String string) {
        String[] result = this.key2splittedKey.get(string);
        if (result != null) {
            return result;
        }
        int size = 0;
        char splitChar = '.';
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != splitChar) continue;
            ++size;
        }
        result = new String[size + 1];
        char[] chars = string.toCharArray();
        int start = 0;
        int j = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != splitChar) continue;
            if (i - start > 0) {
                result[j++] = String.valueOf(chars, start, i - start);
            }
            start = i + 1;
        }
        result[j] = String.valueOf(chars, start, chars.length - start);
        this.key2splittedKey.put(string, result);
        return result;
    }

    public String numerify(String numberString) {
        char[] res = new char[numberString.length()];
        for (int i = 0; i < numberString.length(); ++i) {
            res[i] = numberString.charAt(i) == '#' ? DIGITS.charAt(this.randomService.nextInt(10)) : numberString.charAt(i);
        }
        return String.valueOf(res);
    }

    public String bothify(String string) {
        return this.letterify(this.numerify(string));
    }

    public String bothify(String string, boolean isUpper) {
        return this.letterify(this.numerify(string), isUpper);
    }

    public String regexify(String regex) {
        Generex generex = this.expression2generex.get(regex);
        if (generex == null) {
            generex = new Generex(regex);
            generex.setSeed(this.randomService.nextLong());
            this.expression2generex.put(regex, generex);
        }
        return generex.random();
    }

    public String examplify(String example) {
        if (example == null) {
            return null;
        }
        char[] chars = example.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) {
                chars[i] = this.letterify("?", Character.isUpperCase(chars[i])).charAt(0);
                continue;
            }
            if (!Character.isDigit(chars[i])) continue;
            chars[i] = DIGITS.charAt(this.randomService.nextInt(10));
        }
        return String.valueOf(chars);
    }

    public String letterify(String letterString) {
        return this.letterify(letterString, false);
    }

    public String letterify(String letterString, boolean isUpper) {
        return this.letterHelper(isUpper ? 65 : 97, letterString);
    }

    public String templatify(String letterString, char char2replace, String ... options) {
        return this.templatify(letterString, Collections.singletonMap(Character.valueOf(char2replace), options));
    }

    public String templatify(String letterString, Map<Character, String[]> optionsMap) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < letterString.length(); ++i) {
            if (optionsMap.containsKey(Character.valueOf(letterString.charAt(i)))) {
                String[] options = optionsMap.get(Character.valueOf(letterString.charAt(i)));
                Objects.requireNonNull(options, "Array with available options should be non null");
                sb.append(options[this.randomService.nextInt(options.length)]);
                continue;
            }
            sb.append(letterString.charAt(i));
        }
        return sb.toString();
    }

    private String letterHelper(int baseChar, String letterString) {
        char[] res = letterString.toCharArray();
        for (int i = 0; i < letterString.length(); ++i) {
            if (letterString.charAt(i) != '?') continue;
            res[i] = (char)(baseChar + this.randomService.nextInt(26));
        }
        return String.valueOf(res);
    }

    public String resolve(String key, Object current, Faker root) {
        return this.resolve(key, current, root, () -> key + " resulted in null expression");
    }

    public String resolve(String key, Object current, Faker root, Supplier<String> exceptionMessage) {
        String expression;
        String string = expression = root == null ? this.key2Expression.get(key) : null;
        if (expression == null) {
            expression = this.safeFetch(key, null);
            if (root == null) {
                this.key2Expression.put(key, expression);
            }
        }
        if (expression == null) {
            throw new RuntimeException(exceptionMessage.get());
        }
        return this.resolveExpression(expression, current, root);
    }

    public String expression(String expression, Faker faker) {
        return this.resolveExpression(expression, null, faker);
    }

    public String fileExpression(Path path, Faker faker) {
        try {
            return Files.readAllLines(path).stream().map(t -> this.expression((String)t, faker)).collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String csv(int limit, String ... columnExpressions) {
        return this.csv(",", '\"', true, limit, columnExpressions);
    }

    public String csv(String delimiter, char quote, boolean withHeader, int limit, String ... columnExpressions) {
        if (columnExpressions.length % 2 != 0) {
            throw new IllegalArgumentException("Total number of column names and column values should be even");
        }
        Csv.Column[] columns = new Csv.Column[columnExpressions.length / 2];
        for (int i = 0; i < columnExpressions.length; i += 2) {
            int index = i;
            columns[i / 2] = Csv.Column.of(() -> columnExpressions[index], () -> columnExpressions[index + 1]);
        }
        return ((Csv.CsvBuilder)((Csv.CsvBuilder)((Csv.CsvBuilder)((Csv.CsvBuilder)Format.toCsv(columns).separator(delimiter)).quote(quote)).header(withHeader)).limit(limit)).build().get();
    }

    public Json json(String ... fieldExpressions) {
        if (fieldExpressions.length % 2 != 0) {
            throw new IllegalArgumentException("Total number of field names and field values should be even");
        }
        Json.JsonBuilder jsonBuilder = new Json.JsonBuilder();
        for (int i = 0; i < fieldExpressions.length; i += 2) {
            int index = i;
            jsonBuilder.set(fieldExpressions[index], () -> fieldExpressions[index + 1]);
        }
        return jsonBuilder.build();
    }

    public Json jsona(String ... fieldExpressions) {
        if (fieldExpressions.length % 3 != 0) {
            throw new IllegalArgumentException("Total number of field names and field values should be dividable by 3");
        }
        Json.JsonBuilder jsonBuilder = new Json.JsonBuilder();
        for (int i = 0; i < fieldExpressions.length; i += 3) {
            int index = i;
            if (fieldExpressions[i] != null && Integer.parseInt(fieldExpressions[index]) > 0) {
                Object[] objects = new Object[Integer.parseInt(fieldExpressions[index])];
                Arrays.fill(objects, fieldExpressions[index + 2]);
                jsonBuilder.set(fieldExpressions[index + 1], () -> objects).build();
                continue;
            }
            jsonBuilder.set(fieldExpressions[index + 1], () -> fieldExpressions[index + 2]);
        }
        return jsonBuilder.build();
    }

    protected String resolveExpression(String expression, Object current, Faker root) {
        List<String> expressions = FakeValuesService.splitExpressions(expression);
        ArrayList<Supplier<String>> expressionSuppliers = new ArrayList<Supplier<String>>(expressions.size());
        for (int i = 0; i < expressions.size(); ++i) {
            int j;
            if (i % 2 == 0) {
                int index = i;
                expressionSuppliers.add(() -> (String)expressions.get(index));
                continue;
            }
            String expr = expressions.get(i);
            for (j = 0; j < expr.length() && !Character.isWhitespace(expr.charAt(j)); ++j) {
            }
            String directive = expr.substring(0, j);
            while (j < expr.length() && Character.isWhitespace(expr.charAt(j))) {
                ++j;
            }
            String arguments = j == expr.length() ? "" : expr.substring(j);
            String[] args = this.splitArguments(arguments);
            Object resolved = this.resolveExpression(expr, directive, args, current, root);
            if (resolved == null) {
                throw new RuntimeException("Unable to resolve #{" + expr + "} directive.");
            }
            expressionSuppliers.add(() -> this.resolveExpression(Objects.toString(resolved), current, root));
        }
        return expressionSuppliers.stream().map(Supplier::get).collect(Collectors.joining());
    }

    private String[] splitArguments(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return EMPTY_ARRAY;
        }
        String[] res = this.args2splittedArgs.get(arguments);
        if (res != null) {
            return res;
        }
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        boolean argsStarted = false;
        for (int i = 0; i < arguments.length(); ++i) {
            if (argsStarted) {
                int cnt = 0;
                while (i < arguments.length() && arguments.charAt(i) == '\'') {
                    ++cnt;
                    ++i;
                }
                if (cnt % 2 != 1) continue;
                result.add(arguments.substring(start, i - 1).replaceAll("''", "'"));
                argsStarted = false;
                continue;
            }
            if (arguments.charAt(i) != '\'') continue;
            argsStarted = true;
            start = i + 1;
        }
        this.args2splittedArgs.put(arguments, result.toArray(EMPTY_ARRAY));
        return this.args2splittedArgs.get(arguments);
    }

    private static List<String> splitExpressions(String expression) {
        ArrayList<String> result = new ArrayList<String>();
        boolean isExpression = false;
        int start = 0;
        int quoteCnt = 0;
        for (int i = 0; i < expression.length(); ++i) {
            if (isExpression) {
                if (expression.charAt(i) == '}' && quoteCnt % 2 == 0) {
                    result.add(expression.substring(start, i));
                    start = i + 1;
                    isExpression = false;
                    continue;
                }
                if (expression.charAt(i) != '\'') continue;
                ++quoteCnt;
                continue;
            }
            if (i >= expression.length() - 2 || expression.charAt(i) != '#' || expression.charAt(i + 1) != '{') continue;
            result.add(expression.substring(start, i));
            isExpression = true;
            start = i + 2;
            ++i;
        }
        result.add(start < expression.length() ? expression.substring(start) : "");
        return result;
    }

    private Object resolveExpression(String expression, String directive, String[] args, Object current, Faker root) {
        Object resolved;
        Supplier<Object> supplier;
        String simpleDirective;
        String string = simpleDirective = this.isDotDirective(directive) || current == null ? directive : this.classNameToYamlName(current) + "." + directive;
        if (!this.isDotDirective(directive) && (supplier = this.resolveFromMethodOn(current, directive, args)) != null && (resolved = supplier.get()) != null) {
            return resolved;
        }
        supplier = () -> this.safeFetch(simpleDirective, null);
        resolved = supplier.get();
        if (resolved != null) {
            return resolved;
        }
        if (!this.isDotDirective(directive) && (supplier = this.resolveFromMethodOn(root, directive, args)) != null && (resolved = supplier.get()) != null) {
            return resolved;
        }
        if (this.isDotDirective(directive) && (supplier = this.resolveFakerObjectAndMethod(root, directive, args)) != null && (resolved = supplier.get()) != null) {
            return resolved;
        }
        if (this.isDotDirective(directive)) {
            supplier = () -> this.safeFetch(this.javaNameToYamlName(simpleDirective), null);
            resolved = supplier.get();
        }
        return resolved;
    }

    private boolean isSlashDelimitedRegex(String expression) {
        return expression != null && expression.startsWith("/") && expression.endsWith("/");
    }

    private String trimRegexSlashes(String slashDelimitedRegex) {
        return slashDelimitedRegex.substring(1, slashDelimitedRegex.length() - 1);
    }

    private boolean isDotDirective(String directive) {
        return directive.contains(".");
    }

    private String classNameToYamlName(Object current) {
        return this.javaNameToYamlName(current.getClass().getSimpleName());
    }

    private String javaNameToYamlName(String expression) {
        StringBuilder sb = new StringBuilder(expression.length());
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (Character.isUpperCase(c)) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Supplier<Object> resolveFromMethodOn(Object obj, String directive, String[] args) {
        if (obj == null) {
            return null;
        }
        try {
            MethodAndCoercedArgs accessor = this.accessor(obj, directive, args);
            return accessor == null ? () -> null : () -> this.invokeAndToString(accessor, obj);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Can't call " + directive + " on " + obj, e);
            return () -> null;
        }
    }

    private Supplier<Object> resolveFakerObjectAndMethod(Faker faker, String key, String[] args) {
        int index = key.indexOf(46);
        String[] classAndMethod = index == -1 ? new String[]{key} : new String[]{key.substring(0, index), index == key.length() - 1 ? "" : key.substring(index + 1)};
        try {
            String nestedMethodName;
            String fakerMethodName = FakeValuesService.removeChars(classAndMethod[0], '_');
            MethodAndCoercedArgs fakerAccessor = this.accessor(faker, fakerMethodName, EMPTY_ARRAY);
            if (fakerAccessor == null) {
                LOG.fine("Can't find top level faker object named " + fakerMethodName + ".");
                return null;
            }
            Object objectWithMethodToInvoke = fakerAccessor.invoke(faker);
            MethodAndCoercedArgs accessor = this.accessor(objectWithMethodToInvoke, nestedMethodName = FakeValuesService.removeChars(classAndMethod[1], '_'), args);
            if (accessor == null) {
                throw new Exception("Can't find method on " + objectWithMethodToInvoke.getClass().getSimpleName() + " called " + nestedMethodName + ".");
            }
            return () -> this.invokeAndToString(accessor, objectWithMethodToInvoke);
        }
        catch (Exception e) {
            LOG.fine(e.getMessage());
            return () -> null;
        }
    }

    private Object invokeAndToString(MethodAndCoercedArgs accessor, Object objectWithMethodToInvoke) {
        try {
            return accessor.invoke(objectWithMethodToInvoke);
        }
        catch (Exception e) {
            LOG.fine(e.getMessage());
            return null;
        }
    }

    private MethodAndCoercedArgs accessor(Object onObject, String name, String[] args) {
        LOG.log(Level.FINE, () -> "Find accessor named " + name + " on " + onObject.getClass().getSimpleName() + " with args " + Arrays.toString(args));
        Class<?> clazz = onObject.getClass();
        if (!this.class2methodsCache.containsKey(clazz)) {
            HashMap<String, Collection> methodMap = new HashMap<String, Collection>();
            for (Method m : clazz.getMethods()) {
                String key = m.getName().toLowerCase(Locale.ROOT);
                methodMap.computeIfAbsent(key, k -> new ArrayList());
                ((Collection)methodMap.get(key)).add(m);
            }
            this.class2methodsCache.put(clazz, methodMap);
        }
        Collection methods = this.class2methodsCache.get(clazz).getOrDefault(name.toLowerCase(Locale.ROOT), Collections.emptyList());
        for (Method m : methods) {
            Object[] coercedArguments;
            if (m.getParameterTypes().length != args.length && (m.getParameterTypes().length >= args.length || !m.isVarArgs()) || (coercedArguments = this.coerceArguments(m, args)) == null) continue;
            return new MethodAndCoercedArgs(m, coercedArguments);
        }
        if (name.contains("_")) {
            return this.accessor(onObject, FakeValuesService.removeChars(name, '_'), args);
        }
        return null;
    }

    private static String removeChars(String string, char char2remove) {
        char[] res = string.toCharArray();
        int offset = 0;
        int length = 0;
        for (int i = string.length() - 1; i >= offset; --i) {
            while (i > offset && string.charAt(i - offset) == char2remove) {
                ++offset;
            }
            res[i] = res[i - offset];
            if (res[i] == char2remove) continue;
            ++length;
        }
        return String.valueOf(res, string.length() - length, length);
    }

    private Object[] coerceArguments(Method accessor, String[] args) {
        Object[] coerced = new Object[accessor.getParameterTypes().length];
        for (int i = 0; i < accessor.getParameterTypes().length; ++i) {
            boolean isVarArg = i == accessor.getParameterTypes().length - 1 && accessor.isVarArgs();
            Class<?> toType = FakeValuesService.primitiveToWrapper(accessor.getParameterTypes()[i]);
            toType = isVarArg ? toType.getComponentType() : toType;
            try {
                Constructor<?> ctor;
                Object coercedArgument;
                if (toType.isEnum()) {
                    Method method = toType.getMethod("valueOf", String.class);
                    if (isVarArg) {
                        coercedArgument = Array.newInstance(toType, args.length - i);
                        for (int j = i; j < args.length; ++j) {
                            String enumArg = args[j].substring(args[j].indexOf(".") + 1);
                            Array.set(coercedArgument, j - i, method.invoke(null, enumArg));
                        }
                    } else {
                        String enumArg = args[i].substring(args[i].indexOf(".") + 1);
                        coercedArgument = method.invoke(null, enumArg);
                    }
                } else if (isVarArg) {
                    ctor = this.class2constructorCache.get(toType);
                    if (ctor == null) {
                        for (Constructor<?> c : toType.getConstructors()) {
                            if (c.getParameterCount() != 1 || c.getParameterTypes()[0] != String.class) continue;
                            ctor = toType.getConstructor(String.class);
                            this.class2constructorCache.put(toType, ctor);
                            break;
                        }
                    }
                    if (ctor == null) {
                        return null;
                    }
                    coercedArgument = Array.newInstance(toType, args.length - i);
                    for (int j = i; j < args.length; ++j) {
                        Array.set(coercedArgument, j - i, ctor.newInstance(args[j]));
                    }
                } else if (toType == Character.class) {
                    coercedArgument = args[i] == null ? null : Character.valueOf(args[i].charAt(0));
                } else if (CharSequence.class.isAssignableFrom(toType)) {
                    coercedArgument = args[i];
                } else if (Boolean.class.isAssignableFrom(toType)) {
                    coercedArgument = Boolean.valueOf(args[i]);
                } else if (Integer.class.isAssignableFrom(toType)) {
                    coercedArgument = Integer.valueOf(args[i]);
                } else if (Long.class.isAssignableFrom(toType)) {
                    coercedArgument = Long.valueOf(args[i]);
                } else if (Double.class.isAssignableFrom(toType)) {
                    coercedArgument = Double.valueOf(args[i]);
                } else if (Float.class.isAssignableFrom(toType)) {
                    coercedArgument = Float.valueOf(args[i]);
                } else if (Byte.class.isAssignableFrom(toType)) {
                    coercedArgument = Byte.valueOf(args[i]);
                } else if (Short.class.isAssignableFrom(toType)) {
                    coercedArgument = Short.valueOf(args[i]);
                } else if (BigDecimal.class.isAssignableFrom(toType)) {
                    coercedArgument = new BigDecimal(args[i]);
                } else if (BigInteger.class.isAssignableFrom(toType)) {
                    coercedArgument = new BigInteger(args[i]);
                } else {
                    ctor = toType.getConstructor(String.class);
                    coercedArgument = ctor.newInstance(args[i]);
                }
                coerced[i] = coercedArgument;
                continue;
            }
            catch (Exception e) {
                LOG.fine("Unable to coerce " + args[i] + " to " + toType.getSimpleName() + " via " + toType.getSimpleName() + "(String) constructor.");
                return null;
            }
        }
        return coerced;
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return convertedClass;
    }

    private String string(Object obj) {
        return obj == null ? null : obj.toString();
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Void.TYPE, Void.class);
    }

    private static class MethodAndCoercedArgs {
        private final Method method;
        private final Object[] coerced;

        private MethodAndCoercedArgs(Method m, Object[] coerced) {
            this.method = Objects.requireNonNull(m, "method cannot be null");
            this.coerced = Objects.requireNonNull(coerced, "coerced arguments cannot be null");
        }

        private Object invoke(Object on) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(on, this.coerced);
        }
    }
}

