/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public class LocalePicker {
    private static final String resourcePath = "./src/main/resources";
    private final List<String> locales;
    private List<String> shuffledLocales = new ArrayList<String>();
    private final Random random;

    public LocalePicker() {
        this(null);
    }

    public LocalePicker(Random random) {
        this.random = random != null ? random : new Random();
        this.locales = this.getAllSupportedLocales();
    }

    public List<String> getAllSupportedLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        String[] resourceFiles = new File(resourcePath).list();
        int numResourceFiles = 0;
        if (resourceFiles != null) {
            numResourceFiles = resourceFiles.length;
        }
        for (int i = 0; i < numResourceFiles; ++i) {
            String resourceFileName = resourceFiles[i];
            if (!resourceFileName.endsWith(".yml")) continue;
            String localeName = resourceFileName.substring(0, resourceFileName.lastIndexOf(46));
            locales.add(localeName);
        }
        return locales;
    }

    public String getLocaleString(Random random) {
        int randomIndex = random.nextInt(this.locales.size());
        return this.locales.get(randomIndex);
    }

    public String getLocaleStringWithoutReplacement(Random random) {
        if (this.shuffledLocales.isEmpty()) {
            this.shuffledLocales = new ArrayList<String>(this.locales);
            Collections.shuffle(this.shuffledLocales, random);
        }
        String pickedLocale = this.shuffledLocales.get(0);
        this.shuffledLocales.remove(0);
        return pickedLocale;
    }

    public Locale getLocale() {
        String pickedLocale = this.getLocaleString(this.random);
        return new Locale(pickedLocale);
    }

    public Locale getLocaleWithoutReplacement() {
        String pickedLocale = this.getLocaleStringWithoutReplacement(this.random);
        return new Locale(pickedLocale);
    }
}

