/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.Random;

public class RandomService {
    private static final Random SHARED_RANDOM = new Random();
    private final Random random;

    public RandomService() {
        this(SHARED_RANDOM);
    }

    public RandomService(Random random) {
        this.random = random != null ? random : SHARED_RANDOM;
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public Integer nextInt(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public long nextLong(long n) {
        long val;
        long randomLong;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        while ((bits = (randomLong = this.random.nextLong()) << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public long nextLong(long min, long max) {
        return min + (long)(this.nextDouble() * (double)(max - min));
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextDouble(double min, double max) {
        return min + this.nextDouble() * (max - min);
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public String hex() {
        return this.hex(8);
    }

    public String hex(int length) {
        if (length <= 0) {
            return "";
        }
        char[] hexChars = new char[length];
        for (int i = 0; i < length; ++i) {
            int nextHex = this.nextInt(16);
            hexChars[i] = nextHex < 10 ? (char)(48 + nextHex) : (char)(65 + nextHex - 10);
        }
        return new String(hexChars);
    }

    public Random getRandomInternal() {
        return this.random;
    }
}

