/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnFile {
    public static final String YML = ".yml";
    private final String file;
    private final String path;
    private static final List<EnFile> FILES = Stream.of("address.yml", "ancient.yml", "animal.yml", "app.yml", "appliance.yml", "aqua_teen_hunger_force.yml", "artist.yml", "australia.yml", "aviation.yml", "aws.yml", "babylon5.yml", "back_to_the_future.yml", "barcode.yml", "bank.yml", "basketball.yml", "battlefield1.yml", "beer.yml", "blood_type.yml", "bojack_horseman.yml", "book.yml", "bossa_nova.yml", "breaking_bad.yml", "brooklyn_nine_nine.yml", "buffy.yml", "business.yml", "camera.yml", "chuck_norris.yml", "code.yml", "coin.yml", "color.yml", "commerce.yml", "company.yml", "country.yml", "crypto_coin.yml", "currency.yml", "demographic.yml", "dessert.yml", "device.yml", "disease.yml", "domain.yml", "dr_who.yml", "dragon_ball.yml", "dumb_and_dumber.yml", "dune.yml", "educator.yml", "elden_ring.yml", "elder_scrolls.yml", "electrical_components.yml", "esport.yml", "englandfootball.yml", "file.yml", "finance.yml", "food.yml", "formula1.yml", "friends.yml", "funny_name.yml", "game_of_thrones.yml", "gender.yml", "grateful_dead.yml", "hacker.yml", "half_life.yml", "harry_potter.yml", "hearthstone.yml", "heroes.yml", "heroes_of_the_storm.yml", "hey_arnold.yml", "hipster.yml", "hitchhikers_guide_to_the_galaxy.yml", "hobbit.yml", "hobby.yml", "how_i_met_your_mother.yml", "id_number.yml", "internet.yml", "job.yml", "kpop.yml", "lebowski.yml", "lord_of_the_rings.yml", "lorem.yml", "marketing.yml", "matz.yml", "medical.yml", "michael_scott.yml", "military.yml", "minecraft.yml", "most_interesting_man_in_the_world.yml", "mood.yml", "movie.yml", "mountain.yml", "mountaineering.yml", "music.yml", "name.yml", "nation.yml", "nato_phonetic_alphabet.yml", "nigeria.yml", "overwatch.yml", "oscar_movie.yml", "phone_number.yml", "photography.yml", "pokemon.yml", "princess_bride.yml", "programming_language.yml", "relationship.yml", "restaurant.yml", "rick_and_morty.yml", "robin.yml", "rock_band.yml", "rupaul.yml", "science.yml", "seinfeld.yml", "shakespeare.yml", "sip.yml", "size.yml", "slack_emoji.yml", "soul_knight.yml", "space.yml", "starcraft.yml", "star_trek.yml", "star_wars.yml", "stock.yml", "subscription.yml", "superhero.yml", "tea.yml", "team.yml", "the_it_crowd.yml", "tron.yml", "twitter.yml", "twin_peaks.yml", "university.yml", "vehicle.yml", "volleyball.yml", "weather.yml", "witcher.yml", "kaamelott.yml", "touhou.yml", "yoda.yml", "zelda.yml").map(EnFile::new).collect(Collectors.toList());
    private static final List<EnFile> FILES_WITH_A_DIFFERENT_PATH = Arrays.asList(new EnFile("animal.yml", "creature"), new EnFile("cat.yml", "creature"), new EnFile("dog.yml", "creature"), new EnFile("horse.yml", "creature"), new EnFile("league_of_legends.yml", "games"), new EnFile("overwatch.yml", "games"), new EnFile("pokemon.yml", "games"), new EnFile("super_mario.yml", "games"), new EnFile("witcher.yml", "games"), new EnFile("zelda.yml", "games"), new EnFile("elder_scrolls.yml", "games"), new EnFile("phone_number.yml", "cell_phone"), new EnFile("resident_evil.yml", "games"), new EnFile("hearthstone.yml", "games"));
    private static final List<EnFile> ALL_FILES = new ArrayList<EnFile>(FILES);

    private EnFile(String file) {
        this(file, file.endsWith(YML) ? file.substring(0, file.length() - YML.length()) : file);
    }

    private EnFile(String file, String path) {
        this.file = file;
        this.path = path;
    }

    public String getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public static List<EnFile> getFiles() {
        return ALL_FILES;
    }

    static {
        ALL_FILES.addAll(FILES_WITH_A_DIFFERENT_PATH);
    }
}

