/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.xss.config.MicaXssProperties;
import net.dreamlu.mica.xss.core.XssCleaner;
import net.dreamlu.mica.xss.core.XssType;
import net.dreamlu.mica.xss.utils.XssUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Safelist;
import org.springframework.web.util.HtmlUtils;

public class DefaultXssCleaner
implements XssCleaner {
    private final MicaXssProperties properties;

    public DefaultXssCleaner(MicaXssProperties properties) {
        this.properties = properties;
    }

    private static Document.OutputSettings getOutputSettings(MicaXssProperties properties) {
        return new Document.OutputSettings().escapeMode(Entities.EscapeMode.xhtml).prettyPrint(properties.isPrettyPrint());
    }

    @Override
    public String clean(String name, String bodyHtml, XssType type) {
        if (StringUtil.isBlank((CharSequence)bodyHtml)) {
            return bodyHtml;
        }
        MicaXssProperties.Mode mode = this.properties.getMode();
        if (MicaXssProperties.Mode.escape == mode) {
            return HtmlUtils.htmlEscape((String)bodyHtml, (String)Charsets.UTF_8_NAME);
        }
        if (MicaXssProperties.Mode.validate == mode) {
            if (Jsoup.isValid((String)bodyHtml, (Safelist)XssUtil.WHITE_LIST)) {
                return bodyHtml;
            }
            throw type.getXssException(name, bodyHtml, "Xss validate fail, input value:" + bodyHtml);
        }
        String escapedHtml = Jsoup.clean((String)bodyHtml, (String)"", (Safelist)XssUtil.WHITE_LIST, (Document.OutputSettings)DefaultXssCleaner.getOutputSettings(this.properties));
        if (this.properties.isEnableEscape()) {
            return escapedHtml;
        }
        return Entities.unescape((String)escapedHtml);
    }
}

