/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import java.io.IOException;
import net.dreamlu.mica.xss.config.MicaXssProperties;
import net.dreamlu.mica.xss.core.XssCleanDeserializerBase;
import net.dreamlu.mica.xss.core.XssCleaner;
import net.dreamlu.mica.xss.core.XssHolder;
import net.dreamlu.mica.xss.core.XssType;
import net.dreamlu.mica.xss.utils.XssUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonXssClean
extends XssCleanDeserializerBase {
    private static final Logger log = LoggerFactory.getLogger(JacksonXssClean.class);
    private final MicaXssProperties properties;
    private final XssCleaner xssCleaner;

    @Override
    public String clean(String name, String text) throws IOException {
        if (XssHolder.isIgnore(name)) {
            return XssUtil.trim(text, this.properties.isTrimText());
        }
        String value = this.xssCleaner.clean(name, XssUtil.trim(text, this.properties.isTrimText()), XssType.JACKSON);
        log.debug("Json property name:{} value:{} cleaned up by mica-xss, current value is:{}.", new Object[]{name, text, value});
        return value;
    }

    public JacksonXssClean(MicaXssProperties properties, XssCleaner xssCleaner) {
        this.properties = properties;
        this.xssCleaner = xssCleaner;
    }
}

