/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tess4j.util.LoggHelper;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxUtilities {
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertPdf2Tiff(File file) throws IOException {
        File[] fileArray = null;
        try {
            fileArray = PdfBoxUtilities.convertPdf2Png(file);
            File file2 = File.createTempFile("multipage", ".tif");
            ImageIOHelper.mergeTiff(fileArray, file2);
            File file3 = file2;
            return file3;
        }
        finally {
            if (fileArray != null && fileArray.length > 0) {
                File file4 = new File(fileArray[0].getParent());
                for (File file5 : fileArray) {
                    file5.delete();
                }
                file4.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] convertPdf2Png(File file) throws IOException {
        File[] fileArray;
        Path path = Files.createTempDirectory("tessimages", new FileAttribute[0]);
        File file2 = path.toFile();
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load((File)file);
            fileArray = new PDFRenderer(pDDocument);
            for (int i = 0; i < pDDocument.getNumberOfPages(); ++i) {
                BufferedImage bufferedImage = fileArray.renderImageWithDPI(i, 300.0f, ImageType.RGB);
                String string = String.format("workingimage%04d.png", i + 1);
                ImageIOUtil.writeImage((BufferedImage)bufferedImage, (String)new File(file2, string).getAbsolutePath(), (int)300);
            }
        }
        catch (IOException iOException) {
            logger.error("Error extracting PDF Document => " + iOException);
        }
        finally {
            if (file2.list().length == 0) {
                file2.delete();
            }
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (Exception exception) {}
            }
        }
        fileArray = file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().matches("workingimage\\d{4}\\.png$");
            }
        });
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitPdf(File file, File file2, int n, int n2) {
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load((File)file);
            Splitter splitter = new Splitter();
            splitter.setStartPage(n);
            splitter.setEndPage(n2);
            splitter.setSplitAtPage(n2 - n + 1);
            List list = splitter.split(pDDocument);
            if (list.size() == 1) {
                PDDocument pDDocument2 = (PDDocument)list.get(0);
                pDDocument2.save(file2);
                pDDocument2.close();
            } else {
                logger.error("Splitter returned " + list.size() + " documents rather than expected of 1");
            }
        }
        catch (IOException iOException) {
            logger.error("Exception splitting PDF => " + iOException);
        }
        finally {
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPdfPageCount(File file) {
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load((File)file);
            int n = pDDocument.getNumberOfPages();
            return n;
        }
        catch (IOException iOException) {
            logger.error("Error counting PDF pages => " + iOException);
            int n = -1;
            return n;
        }
        finally {
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void mergePdf(File[] fileArray, File file) {
        try {
            PDFMergerUtility pDFMergerUtility = new PDFMergerUtility();
            pDFMergerUtility.setDestinationFileName(file.getPath());
            for (File file2 : fileArray) {
                pDFMergerUtility.addSource(file2);
            }
            pDFMergerUtility.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        }
        catch (IOException iOException) {
            logger.error("Error counting PDF pages => " + iOException);
        }
    }
}

