/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Predicates;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlAbstractStringLiteral;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlInOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.BarfingInvocationHandler;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public abstract class SqlUtil {
    public static final String GENERATED_EXPR_ALIAS_PREFIX = "EXPR$";

    public static SqlNode andExpressions(@Nullable SqlNode node1, SqlNode node2) {
        if (node1 == null) {
            return node2;
        }
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        if (node1.getKind() == SqlKind.AND) {
            list.addAll(((SqlCall)node1).getOperandList());
        } else {
            list.add(node1);
        }
        if (node2.getKind() == SqlKind.AND) {
            list.addAll(((SqlCall)node2).getOperandList());
        } else {
            list.add(node2);
        }
        return SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, list);
    }

    static ArrayList<SqlNode> flatten(SqlNode node) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlUtil.flatten(node, list);
        return list;
    }

    public static SqlNode getFromNode(SqlSelect query, int ordinal) {
        SqlNode from = query.getFrom();
        assert (from != null) : "from must not be null for " + query;
        ArrayList<SqlNode> list = SqlUtil.flatten(from);
        return list.get(ordinal);
    }

    private static void flatten(SqlNode node, ArrayList<SqlNode> list) {
        switch (node.getKind()) {
            case JOIN: {
                SqlJoin join = (SqlJoin)node;
                SqlUtil.flatten(join.getLeft(), list);
                SqlUtil.flatten(join.getRight(), list);
                return;
            }
            case AS: {
                SqlCall call = (SqlCall)node;
                SqlUtil.flatten(call.operand(0), list);
                return;
            }
        }
        list.add(node);
    }

    public static SqlNodeList toNodeList(SqlNode[] operands) {
        SqlNodeList ret = new SqlNodeList(SqlParserPos.ZERO);
        for (SqlNode node : operands) {
            ret.add(node);
        }
        return ret;
    }

    public static int indexOfDeep(List<? extends SqlNode> list, SqlNode e, Litmus litmus) {
        for (int i = 0; i < list.size(); ++i) {
            if (!e.equalsDeep(list.get(i), litmus)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNullLiteral(@Nullable SqlNode node, boolean allowCast) {
        SqlCall call;
        if (node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        return allowCast && node != null && node.getKind() == SqlKind.CAST && SqlUtil.isNullLiteral((call = (SqlCall)node).operand(0), false);
    }

    public static boolean isNull(SqlNode node) {
        return SqlUtil.isNullLiteral(node, false) || node.getKind() == SqlKind.CAST && SqlUtil.isNull(((SqlCall)node).operand(0));
    }

    public static boolean isLiteral(SqlNode node, boolean allowCast) {
        assert (node != null);
        if (node instanceof SqlLiteral) {
            return true;
        }
        if (!allowCast) {
            return false;
        }
        switch (node.getKind()) {
            case CAST: {
                return SqlUtil.isLiteral(((SqlCall)node).operand(0), true);
            }
            case MAP_VALUE_CONSTRUCTOR: 
            case ARRAY_VALUE_CONSTRUCTOR: {
                return ((SqlCall)node).getOperandList().stream().allMatch(o -> SqlUtil.isLiteral(o, true));
            }
            case DEFAULT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLiteral(SqlNode node) {
        return SqlUtil.isLiteral(node, false);
    }

    public static boolean isLiteralChain(SqlNode node) {
        assert (node != null);
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            return call.getKind() == SqlKind.LITERAL_CHAIN;
        }
        return false;
    }

    @Deprecated
    public static void unparseFunctionSyntax(SqlOperator operator, SqlWriter writer, SqlCall call) {
        SqlUtil.unparseFunctionSyntax(operator, writer, call, false);
    }

    public static void unparseFunctionSyntax(SqlOperator operator, SqlWriter writer, SqlCall call, boolean ordered) {
        if (operator instanceof SqlFunction) {
            SqlIdentifier id;
            SqlFunction function = (SqlFunction)operator;
            if (function.getFunctionType().isSpecific()) {
                writer.keyword("SPECIFIC");
            }
            if ((id = function.getSqlIdentifier()) == null) {
                writer.keyword(operator.getName());
            } else {
                SqlUtil.unparseSqlIdentifierSyntax(writer, id, true);
            }
        } else {
            writer.print(operator.getName());
        }
        if (call.operandCount() == 0) {
            switch (call.getOperator().getSyntax()) {
                case FUNCTION_ID: {
                    return;
                }
                case FUNCTION_STAR: 
                case FUNCTION: 
                case ORDERED_FUNCTION: {
                    break;
                }
            }
        }
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
        SqlLiteral quantifier = call.getFunctionQuantifier();
        if (quantifier != null) {
            quantifier.unparse(writer, 0, 0);
        }
        if (call.operandCount() == 0) {
            switch (call.getOperator().getSyntax()) {
                case FUNCTION_STAR: {
                    writer.sep("*");
                    break;
                }
            }
        }
        for (SqlNode operand : call.getOperandList()) {
            if (ordered && operand instanceof SqlNodeList) {
                writer.sep("ORDER BY");
            } else {
                if (ordered && operand.getKind() == SqlKind.SEPARATOR) {
                    writer.sep("SEPARATOR");
                    ((SqlNode)((SqlCall)operand).operand(0)).unparse(writer, 0, 0);
                    continue;
                }
                writer.sep(",");
            }
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    public static void unparseSqlIdentifierSyntax(SqlWriter writer, SqlIdentifier identifier, boolean asFunctionID) {
        boolean isUnquotedSimple = identifier.isSimple() && !identifier.getParserPosition().isQuoted();
        SqlOperator operator = isUnquotedSimple ? SqlValidatorUtil.lookupSqlFunctionByID(SqlStdOperatorTable.instance(), identifier, null) : null;
        boolean unparsedAsFunc = false;
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        if (isUnquotedSimple && operator != null && (asFunctionID || operator.getSyntax() == SqlSyntax.FUNCTION_ID)) {
            writer.keyword(identifier.getSimple());
            unparsedAsFunc = true;
        }
        if (!unparsedAsFunc) {
            for (int i = 0; i < identifier.names.size(); ++i) {
                writer.sep(".");
                String name = (String)identifier.names.get(i);
                SqlParserPos pos = identifier.getComponentParserPosition(i);
                if (name.equals("")) {
                    writer.print("*");
                    writer.setNeedWhitespace(true);
                    continue;
                }
                writer.identifier(name, pos.isQuoted());
            }
        }
        if (null != identifier.getCollation()) {
            identifier.getCollation().unparse(writer);
        }
        writer.endList(frame);
    }

    public static void unparseBinarySyntax(SqlOperator operator, SqlCall call, SqlWriter writer, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(operator instanceof SqlSetOperator ? SqlWriter.FrameTypeEnum.SETOP : SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, operator.getLeftPrec());
        boolean needsSpace = operator.needsSpace();
        writer.setNeedWhitespace(needsSpace);
        writer.sep(operator.getName());
        writer.setNeedWhitespace(needsSpace);
        ((SqlNode)call.operand(1)).unparse(writer, operator.getRightPrec(), rightPrec);
        writer.endList(frame);
    }

    public static SqlLiteral concatenateLiterals(List<SqlLiteral> lits) {
        if (lits.size() == 1) {
            return lits.get(0);
        }
        return ((SqlAbstractStringLiteral)lits.get(0)).concat1(lits);
    }

    public static @Nullable SqlOperator lookupRoutine(SqlOperatorTable opTab, RelDataTypeFactory typeFactory, SqlIdentifier funcName, List<RelDataType> argTypes, @Nullable List<String> argNames, @Nullable SqlFunctionCategory category, SqlSyntax syntax, SqlKind sqlKind, SqlNameMatcher nameMatcher, boolean coerce) {
        Iterator<SqlOperator> list = SqlUtil.lookupSubjectRoutines(opTab, typeFactory, funcName, argTypes, argNames, syntax, sqlKind, category, nameMatcher, coerce);
        if (list.hasNext()) {
            return list.next();
        }
        return null;
    }

    private static Iterator<SqlOperator> filterOperatorRoutinesByKind(Iterator<SqlOperator> routines, SqlKind sqlKind) {
        return Iterators.filter(routines, operator -> Objects.requireNonNull(operator, "operator").getKind() == sqlKind);
    }

    public static Iterator<SqlOperator> lookupSubjectRoutines(SqlOperatorTable opTab, RelDataTypeFactory typeFactory, SqlIdentifier funcName, List<RelDataType> argTypes, @Nullable List<String> argNames, SqlSyntax sqlSyntax, SqlKind sqlKind, @Nullable SqlFunctionCategory category, SqlNameMatcher nameMatcher, boolean coerce) {
        Iterator<SqlOperator> routines = SqlUtil.lookupSubjectRoutinesByName(opTab, funcName, sqlSyntax, category, nameMatcher);
        routines = SqlUtil.filterRoutinesByParameterCount(routines, argTypes);
        if (category == SqlFunctionCategory.USER_DEFINED_PROCEDURE) {
            return routines;
        }
        routines = SqlUtil.filterRoutinesByParameterTypeAndName(typeFactory, sqlSyntax, routines, argTypes, argNames, coerce);
        ArrayList list = Lists.newArrayList(routines);
        routines = list.iterator();
        if (list.size() < 2 || coerce) {
            return routines;
        }
        routines = SqlUtil.filterRoutinesByTypePrecedence(sqlSyntax, typeFactory, routines, argTypes, argNames);
        return SqlUtil.filterOperatorRoutinesByKind(routines, sqlKind);
    }

    public static boolean matchRoutinesByParameterCount(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, SqlFunctionCategory category, SqlNameMatcher nameMatcher) {
        Iterator<SqlOperator> routines = SqlUtil.lookupSubjectRoutinesByName(opTab, funcName, SqlSyntax.FUNCTION, category, nameMatcher);
        routines = SqlUtil.filterRoutinesByParameterCount(routines, argTypes);
        return routines.hasNext();
    }

    private static Iterator<SqlOperator> lookupSubjectRoutinesByName(SqlOperatorTable opTab, SqlIdentifier funcName, SqlSyntax syntax, @Nullable SqlFunctionCategory category, SqlNameMatcher nameMatcher) {
        ArrayList<SqlOperator> sqlOperators = new ArrayList<SqlOperator>();
        opTab.lookupOperatorOverloads(funcName, category, syntax, sqlOperators, nameMatcher);
        switch (syntax) {
            case FUNCTION: {
                return Iterators.filter(sqlOperators.iterator(), (com.google.common.base.Predicate)Predicates.instanceOf(SqlFunction.class));
            }
        }
        return Iterators.filter(sqlOperators.iterator(), operator -> Objects.requireNonNull(operator, "operator").getSyntax() == syntax);
    }

    private static Iterator<SqlOperator> filterRoutinesByParameterCount(Iterator<SqlOperator> routines, List<RelDataType> argTypes) {
        return Iterators.filter(routines, operator -> Objects.requireNonNull(operator, "operator").getOperandCountRange().isValidCount(argTypes.size()));
    }

    private static Iterator<SqlOperator> filterRoutinesByParameterTypeAndName(RelDataTypeFactory typeFactory, SqlSyntax syntax, Iterator<SqlOperator> routines, List<RelDataType> argTypes, @Nullable List<String> argNames, boolean coerce) {
        if (syntax != SqlSyntax.FUNCTION) {
            return routines;
        }
        return Iterators.filter((Iterator)Iterators.filter(routines, SqlFunction.class), function -> {
            List<Object> permutedArgTypes;
            SqlOperandTypeChecker operandTypeChecker = Objects.requireNonNull(function, "function").getOperandTypeChecker();
            if (operandTypeChecker == null || !operandTypeChecker.isFixedParameters()) {
                return true;
            }
            SqlOperandMetadata operandMetadata = (SqlOperandMetadata)operandTypeChecker;
            List<@Nullable RelDataType> paramTypes = operandMetadata.paramTypes(typeFactory);
            if (argNames != null) {
                List<String> paramNames = operandMetadata.paramNames();
                permutedArgTypes = SqlUtil.permuteArgTypes(paramNames, argNames, argTypes);
                if (permutedArgTypes == null) {
                    return false;
                }
            } else {
                permutedArgTypes = Lists.newArrayList((Iterable)argTypes);
                while (permutedArgTypes.size() < argTypes.size()) {
                    paramTypes.add(null);
                }
            }
            for (Pair p : Pair.zip(paramTypes, permutedArgTypes)) {
                RelDataType argType = (RelDataType)p.right;
                RelDataType paramType = (RelDataType)p.left;
                if (argType == null || paramType == null || SqlTypeUtil.canCastFrom(paramType, argType, coerce)) continue;
                return false;
            }
            return true;
        });
    }

    private static @Nullable List<@Nullable RelDataType> permuteArgTypes(List<String> paramNames, List<String> argNames, List<RelDataType> argTypes) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Ord argName : Ord.zip(argNames)) {
            int i = paramNames.indexOf(argName.e);
            if (i < 0) {
                return null;
            }
            map.put(i, argName.i);
        }
        return Functions.generate((int)paramNames.size(), index -> {
            Integer argIndex = (Integer)map.get(index);
            return argIndex != null ? (RelDataType)argTypes.get(argIndex) : null;
        });
    }

    private static Iterator<SqlOperator> filterRoutinesByTypePrecedence(SqlSyntax sqlSyntax, RelDataTypeFactory typeFactory, Iterator<SqlOperator> routines, List<RelDataType> argTypes, @Nullable List<String> argNames) {
        if (sqlSyntax != SqlSyntax.FUNCTION) {
            return routines;
        }
        List<Object> sqlFunctions = Lists.newArrayList((Iterator)Iterators.filter(routines, SqlFunction.class));
        for (Ord argType : Ord.zip(argTypes)) {
            RelDataTypePrecedenceList precList = ((RelDataType)argType.e).getPrecedenceList();
            RelDataType bestMatch = SqlUtil.bestMatch(typeFactory, sqlFunctions, argType.i, argNames, precList);
            if (bestMatch == null) continue;
            sqlFunctions = sqlFunctions.stream().filter(function -> {
                SqlOperandTypeChecker operandTypeChecker = function.getOperandTypeChecker();
                if (operandTypeChecker == null || !operandTypeChecker.isFixedParameters()) {
                    return false;
                }
                SqlOperandMetadata operandMetadata = (SqlOperandMetadata)operandTypeChecker;
                List<String> paramNames = operandMetadata.paramNames();
                List<RelDataType> paramTypes = operandMetadata.paramTypes(typeFactory);
                int index = argNames != null ? paramNames.indexOf(argNames.get(argType.i)) : argType.i;
                RelDataType paramType = paramTypes.get(index);
                return precList.compareTypePrecedence(paramType, bestMatch) >= 0;
            }).collect(Collectors.toList());
        }
        return sqlFunctions.iterator();
    }

    private static @Nullable RelDataType bestMatch(RelDataTypeFactory typeFactory, List<SqlFunction> sqlFunctions, int i, @Nullable List<String> argNames, RelDataTypePrecedenceList precList) {
        RelDataType bestMatch = null;
        for (SqlFunction function : sqlFunctions) {
            RelDataType paramType;
            SqlOperandTypeChecker operandTypeChecker = function.getOperandTypeChecker();
            if (operandTypeChecker == null || !operandTypeChecker.isFixedParameters()) continue;
            SqlOperandMetadata operandMetadata = (SqlOperandMetadata)operandTypeChecker;
            List<RelDataType> paramTypes = operandMetadata.paramTypes(typeFactory);
            List<String> paramNames = operandMetadata.paramNames();
            RelDataType relDataType = paramType = argNames != null ? paramTypes.get(paramNames.indexOf(argNames.get(i))) : paramTypes.get(i);
            if (bestMatch == null) {
                bestMatch = paramType;
                continue;
            }
            int c = precList.compareTypePrecedence(bestMatch, paramType);
            if (c >= 0) continue;
            bestMatch = paramType;
        }
        return bestMatch;
    }

    public static SqlNode getSelectListItem(SqlNode query, int i) {
        switch (query.getKind()) {
            case SELECT: {
                SqlSelect select = (SqlSelect)query;
                SqlNode from = SqlUtil.stripAs(select.getFrom());
                if (from != null && from.getKind() == SqlKind.VALUES) {
                    return SqlUtil.getSelectListItem(from, i);
                }
                SqlNodeList fields = select.getSelectList();
                assert (fields != null) : "fields must not be null in " + select;
                if (i >= fields.size()) {
                    i = 0;
                }
                return fields.get(i);
            }
            case VALUES: {
                SqlCall call = (SqlCall)query;
                assert (call.operandCount() > 0) : "VALUES must have at least one operand";
                SqlCall row = (SqlCall)call.operand(0);
                assert (row.operandCount() > i) : "VALUES has too few columns";
                return row.operand(i);
            }
        }
        throw Util.needToImplement(query);
    }

    public static String deriveAliasFromOrdinal(int ordinal) {
        return GENERATED_EXPR_ALIAS_PREFIX + ordinal;
    }

    public static boolean isGeneratedAlias(String alias) {
        assert (alias != null);
        return alias.toUpperCase(Locale.ROOT).startsWith(GENERATED_EXPR_ALIAS_PREFIX);
    }

    public static String getOperatorSignature(SqlOperator op, List<?> typeList) {
        return SqlUtil.getAliasedSignature(op, op.getName(), typeList);
    }

    public static String getAliasedSignature(SqlOperator op, String opName, List<?> typeList) {
        StringBuilder ret = new StringBuilder();
        String template = op.getSignatureTemplate(typeList.size());
        if (null == template) {
            ret.append("'");
            ret.append(opName);
            ret.append("(");
            for (int i = 0; i < typeList.size(); ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                String t = String.valueOf(typeList.get(i)).toUpperCase(Locale.ROOT);
                ret.append("<").append(t).append(">");
            }
            ret.append(")'");
        } else {
            Object[] values = new Object[typeList.size() + 1];
            values[0] = opName;
            ret.append("'");
            for (int i = 0; i < typeList.size(); ++i) {
                String t = String.valueOf(typeList.get(i)).toUpperCase(Locale.ROOT);
                values[i + 1] = "<" + t + ">";
            }
            ret.append(new MessageFormat(template, Locale.ROOT).format(values));
            ret.append("'");
            assert (typeList.size() + 1 == values.length);
        }
        return ret.toString();
    }

    public static CalciteException newContextException(SqlParserPos pos, Resources.ExInst<?> e, String inputText) {
        CalciteContextException ex = SqlUtil.newContextException(pos, e);
        ex.setOriginalStatement(inputText);
        return ex;
    }

    public static CalciteContextException newContextException(SqlParserPos pos, Resources.ExInst<?> e) {
        int line = pos.getLineNum();
        int col = pos.getColumnNum();
        int endLine = pos.getEndLineNum();
        int endCol = pos.getEndColumnNum();
        return SqlUtil.newContextException(line, col, endLine, endCol, e);
    }

    public static CalciteContextException newContextException(int line, int col, int endLine, int endCol, Resources.ExInst<?> e) {
        CalciteContextException contextExcn = (line == endLine && col == endCol ? Static.RESOURCE.validatorContextPoint(line, col) : Static.RESOURCE.validatorContext(line, col, endLine, endCol)).ex((Throwable)e.ex());
        contextExcn.setPosition(line, col, endLine, endCol);
        return contextExcn;
    }

    public static boolean isCallTo(SqlNode node, SqlOperator operator) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator() == operator;
    }

    public static RelDataType createNlsStringType(RelDataTypeFactory typeFactory, NlsString str) {
        SqlCollation collation;
        Charset charset = str.getCharset();
        if (null == charset) {
            charset = typeFactory.getDefaultCharset();
        }
        if (null == (collation = str.getCollation())) {
            collation = SqlCollation.COERCIBLE;
        }
        RelDataType type = typeFactory.createSqlType(SqlTypeName.CHAR, str.getValue().length());
        type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        return type;
    }

    public static @Nullable String translateCharacterSetName(String name) {
        switch (name) {
            case "BIG5": {
                return "Big5";
            }
            case "LATIN1": {
                return "ISO-8859-1";
            }
            case "UTF8": {
                return "UTF-8";
            }
            case "UTF16": 
            case "UTF-16": {
                return ConversionUtil.NATIVE_UTF16_CHARSET_NAME;
            }
            case "GB2312": 
            case "GBK": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "ISO-8859-1": 
            case "UTF-8": {
                return name;
            }
        }
        return null;
    }

    public static Charset getCharset(String charsetName) {
        assert (charsetName != null);
        String javaCharsetName = SqlUtil.translateCharacterSetName(charsetName = charsetName.toUpperCase(Locale.ROOT));
        if (javaCharsetName == null) {
            throw new UnsupportedCharsetException(charsetName);
        }
        return Charset.forName(javaCharsetName);
    }

    public static void validateCharset(ByteString value, Charset charset) {
        byte[] bytes;
        if (charset == StandardCharsets.UTF_8 && !Utf8.isWellFormed((byte[])(bytes = value.getBytes()))) {
            String string = new String(bytes, charset);
            throw Static.RESOURCE.charsetEncoding(string, charset.name()).ex();
        }
    }

    public static @PolyNull SqlNode stripAs(@PolyNull SqlNode node) {
        if (node != null && node.getKind() == SqlKind.AS) {
            return ((SqlCall)node).operand(0);
        }
        return node;
    }

    public static SqlNodeList stripListAs(SqlNodeList nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            SqlNode n2;
            SqlNode n = nodeList.get(i);
            if (n == (n2 = SqlUtil.stripAs(n))) continue;
            nodeList.set(i, n2);
        }
        return nodeList;
    }

    public static ImmutableList<SqlNode> getAncestry(SqlNode root, Predicate<SqlNode> predicate, Predicate<SqlNode> postPredicate) {
        try {
            new Genealogist(predicate, postPredicate).visitChild(root);
            throw new AssertionError((Object)("not found: " + predicate + " in " + root));
        }
        catch (Util.FoundOne e) {
            return (ImmutableList)Objects.requireNonNull(e.getNode(), "Genealogist result");
        }
    }

    public static List<RelHint> getRelHint(HintStrategyTable hintStrategies, @Nullable SqlNodeList sqlHints) {
        if (sqlHints == null || sqlHints.size() == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder relHints = ImmutableList.builder();
        for (SqlNode node : sqlHints) {
            RelHint relHint;
            assert (node instanceof SqlHint);
            SqlHint sqlHint = (SqlHint)node;
            String hintName = sqlHint.getName();
            RelHint.Builder builder = RelHint.builder(hintName);
            switch (sqlHint.getOptionFormat()) {
                case EMPTY: {
                    break;
                }
                case LITERAL_LIST: 
                case ID_LIST: {
                    builder.hintOptions(sqlHint.getOptionList());
                    break;
                }
                case KV_LIST: {
                    builder.hintOptions(sqlHint.getOptionKVPairs());
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected hint option format");
                }
            }
            if (!hintStrategies.validateHint(relHint = builder.build())) continue;
            relHints.add((Object)relHint);
        }
        return relHints.build();
    }

    public static RelNode attachRelHint(HintStrategyTable hintStrategies, List<RelHint> hints, Hintable rel) {
        List<RelHint> relHints = hintStrategies.apply(hints, (RelNode)((Object)rel));
        if (relHints.size() > 0) {
            return rel.attachHints(relHints);
        }
        return (RelNode)((Object)rel);
    }

    public static SqlNode createCall(SqlOperator op, SqlParserPos pos, List<SqlNode> operands) {
        switch (op.kind) {
            case OR: 
            case AND: {
                switch (operands.size()) {
                    case 0: {
                        return SqlLiteral.createBoolean(op.kind == SqlKind.AND, pos);
                    }
                    case 1: {
                        return operands.get(0);
                    }
                    default: {
                        return SqlUtil.createBalancedCall(op, pos, operands, 0, operands.size());
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                }
                break;
            }
        }
        if (op instanceof SqlBinaryOperator && operands.size() > 2) {
            return SqlUtil.createLeftCall(op, pos, operands);
        }
        return op.createCall(pos, operands);
    }

    private static SqlNode createLeftCall(SqlOperator op, SqlParserPos pos, List<SqlNode> nodeList) {
        SqlCall node = op.createCall(pos, nodeList.subList(0, 2));
        for (int i = 2; i < nodeList.size(); ++i) {
            node = op.createCall(pos, node, nodeList.get(i));
        }
        return node;
    }

    private static SqlNode createBalancedCall(SqlOperator op, SqlParserPos pos, List<SqlNode> operands, int start, int end) {
        assert (start < end && end <= operands.size());
        if (start + 1 == end) {
            return operands.get(start);
        }
        int mid = (end - start) / 2 + start;
        SqlNode leftNode = SqlUtil.createBalancedCall(op, pos, operands, start, mid);
        SqlNode rightNode = SqlUtil.createBalancedCall(op, pos, operands, mid, end);
        return op.createCall(pos, leftNode, rightNode);
    }

    public static boolean containsIn(SqlNode node) {
        Predicate<SqlCall> callPredicate = call -> call.getOperator() instanceof SqlInOperator;
        return SqlUtil.containsCall(node, callPredicate);
    }

    public static boolean containsDefault(SqlNode node) {
        Predicate<SqlCall> callPredicate = call -> call.getKind() == SqlKind.DEFAULT;
        return SqlUtil.containsCall(node, callPredicate);
    }

    public static boolean containsAgg(SqlNode node) {
        Predicate<SqlCall> callPredicate = call -> call.getOperator().isAggregator();
        return SqlUtil.containsCall(node, callPredicate);
    }

    private static boolean containsCall(SqlNode node, final Predicate<SqlCall> callPredicate) {
        try {
            SqlBasicVisitor<Void> visitor = new SqlBasicVisitor<Void>(){

                @Override
                public Void visit(SqlCall call) {
                    if (callPredicate.test(call)) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visit(call);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    private static class Genealogist
    extends SqlBasicVisitor<Void> {
        private final List<SqlNode> ancestors = new ArrayList<SqlNode>();
        private final Predicate<SqlNode> predicate;
        private final Predicate<SqlNode> postPredicate;

        Genealogist(Predicate<SqlNode> predicate, Predicate<SqlNode> postPredicate) {
            this.predicate = predicate;
            this.postPredicate = postPredicate;
        }

        private Void check(SqlNode node) {
            this.preCheck(node);
            this.postCheck(node);
            return null;
        }

        private Void preCheck(SqlNode node) {
            if (this.predicate.test(node)) {
                throw new Util.FoundOne(ImmutableList.copyOf(this.ancestors));
            }
            return null;
        }

        private Void postCheck(SqlNode node) {
            if (this.postPredicate.test(node)) {
                throw new Util.FoundOne(ImmutableList.copyOf(this.ancestors));
            }
            return null;
        }

        private void visitChild(@Nullable SqlNode node) {
            if (node == null) {
                return;
            }
            this.ancestors.add(node);
            node.accept(this);
            this.ancestors.remove(this.ancestors.size() - 1);
        }

        @Override
        public Void visit(SqlIdentifier id) {
            return this.check(id);
        }

        @Override
        public Void visit(SqlCall call) {
            this.preCheck(call);
            for (SqlNode node : call.getOperandList()) {
                this.visitChild(node);
            }
            return this.postCheck(call);
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            return this.check(intervalQualifier);
        }

        @Override
        public Void visit(SqlLiteral literal) {
            return this.check(literal);
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            this.preCheck(nodeList);
            for (SqlNode node : nodeList) {
                this.visitChild(node);
            }
            return this.postCheck(nodeList);
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            return this.check(param);
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            return this.check(type);
        }
    }

    public static class DatabaseMetaDataInvocationHandler
    extends BarfingInvocationHandler {
        private final String databaseProductName;
        private final String identifierQuoteString;

        public DatabaseMetaDataInvocationHandler(String databaseProductName, String identifierQuoteString) {
            this.databaseProductName = databaseProductName;
            this.identifierQuoteString = identifierQuoteString;
        }

        public String getDatabaseProductName() throws SQLException {
            return this.databaseProductName;
        }

        public String getIdentifierQuoteString() throws SQLException {
            return this.identifierQuoteString;
        }
    }
}

