/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.CloseableUtils;

public class AgentForwardSupport
extends CloseableUtils.AbstractCloseable {
    private final ConnectionService service;
    private String agentId;
    private SshAgentServer agentServer;

    public AgentForwardSupport(ConnectionService service) {
        this.service = service;
    }

    public String initialize() throws IOException {
        try {
            if (this.agentId == null) {
                this.agentServer = this.service.getSession().getFactoryManager().getAgentFactory().createServer(this.service);
                this.agentId = this.agentServer.getId();
            }
            return this.agentId;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.agentId != null) {
            this.agentId = null;
            this.agentServer.close();
            this.agentServer = null;
        }
    }

    @Override
    protected void doCloseImmediately() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
        }
        super.doCloseImmediately();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.service.getSession() + "]";
    }
}

