/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.kex.DHGClient;
import org.apache.sshd.client.kex.DHGEXClient;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.util.Transformer;
import org.apache.sshd.server.forward.ForwardedTcpipFactory;

public class ClientBuilder
extends BaseBuilder<SshClient, ClientBuilder> {
    public static final Transformer<DHFactory, NamedFactory<KeyExchange>> DH2KEX = new Transformer<DHFactory, NamedFactory<KeyExchange>>(){

        @Override
        public NamedFactory<KeyExchange> transform(DHFactory factory) {
            if (factory == null) {
                return null;
            }
            if (factory.isGroupExchange()) {
                return DHGEXClient.newFactory(factory);
            }
            return DHGClient.newFactory(factory);
        }
    };
    public static final List<NamedFactory<Channel>> DEFAULT_CHANNEL_FACTORIES = Collections.unmodifiableList(Arrays.asList(ForwardedTcpipFactory.INSTANCE));
    public static final ServerKeyVerifier DEFAULT_SERVER_KEY_VERIFIER = AcceptAllServerKeyVerifier.INSTANCE;
    protected ServerKeyVerifier serverKeyVerifier;

    public ClientBuilder serverKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
        return (ClientBuilder)this.me();
    }

    @Override
    protected ClientBuilder fillWithDefaultValues() {
        super.fillWithDefaultValues();
        if (this.keyExchangeFactories == null) {
            this.keyExchangeFactories = ClientBuilder.setUpDefaultKeyExchanges(false);
        }
        if (this.channelFactories == null) {
            this.channelFactories = DEFAULT_CHANNEL_FACTORIES;
        }
        if (this.serverKeyVerifier == null) {
            this.serverKeyVerifier = DEFAULT_SERVER_KEY_VERIFIER;
        }
        if (this.factory == null) {
            this.factory = SshClient.DEFAULT_SSH_CLIENT_FACTORY;
        }
        return (ClientBuilder)this.me();
    }

    @Override
    public SshClient build(boolean isFillWithDefaultValues) {
        SshClient client = (SshClient)super.build(isFillWithDefaultValues);
        client.setServerKeyVerifier(this.serverKeyVerifier);
        return client;
    }

    public static List<NamedFactory<KeyExchange>> setUpDefaultKeyExchanges(boolean ignoreUnsupported) {
        return NamedFactory.Utils.setUpTransformedFactories(ignoreUnsupported, DEFAULT_KEX_PREFERENCE, DH2KEX);
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }
}

