/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class UserAuthPublicKey
extends AbstractLoggingBean
implements UserAuth {
    private ClientSession session;
    private String service;
    private SshAgent agent;
    private Iterator<PublicKeyIdentity> keys;
    private PublicKeyIdentity current;

    @Override
    public void init(ClientSession session, String service, Collection<?> identities) throws Exception {
        KeyPairProvider provider;
        this.session = session;
        this.service = service;
        ArrayList<PublicKeyIdentity> ids = new ArrayList<PublicKeyIdentity>();
        for (Object o : identities) {
            if (!(o instanceof KeyPair)) continue;
            ids.add(new KeyPairIdentity(session.getFactoryManager(), (KeyPair)o));
        }
        ClientFactoryManager manager = session.getFactoryManager();
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory != null) {
            this.agent = factory.createClient(manager);
            for (Pair<PublicKey, String> pair : this.agent.getIdentities()) {
                ids.add(new KeyAgentIdentity(this.agent, pair.getFirst()));
            }
        } else {
            this.agent = null;
        }
        if ((provider = manager.getKeyPairProvider()) != null) {
            for (KeyPair pair : provider.loadKeys()) {
                ids.add(new KeyPairIdentity(manager, pair));
            }
        }
        this.keys = ids.iterator();
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        if (buffer == null) {
            if (this.keys.hasNext()) {
                this.current = this.keys.next();
                PublicKey key = this.current.getPublicKey();
                String algo = KeyUtils.getKeyType(key);
                this.log.debug("Send SSH_MSG_USERAUTH_REQUEST request publickey algo={}", (Object)algo);
                buffer = this.session.createBuffer((byte)50);
                buffer.putString(this.session.getUsername());
                buffer.putString(this.service);
                buffer.putString("publickey");
                buffer.putBoolean(false);
                buffer.putString(algo);
                buffer.putPublicKey(key);
                this.session.writePacket(buffer);
                return true;
            }
            this.log.debug("No more keys to send");
            return false;
        }
        int cmd = buffer.getUByte();
        if (cmd == 60) {
            PublicKey key = this.current.getPublicKey();
            String algo = KeyUtils.getKeyType(key);
            this.log.debug("Send SSH_MSG_USERAUTH_REQUEST reply publickey algo={}", (Object)algo);
            buffer = this.session.createBuffer((byte)50);
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("publickey");
            buffer.putBoolean(true);
            buffer.putString(algo);
            buffer.putPublicKey(key);
            ByteArrayBuffer bs = new ByteArrayBuffer();
            bs.putBytes(this.session.getKex().getH());
            ((Buffer)bs).putByte((byte)50);
            bs.putString(this.session.getUsername());
            bs.putString(this.service);
            bs.putString("publickey");
            bs.putBoolean(true);
            bs.putString(algo);
            bs.putPublicKey(key);
            byte[] sig = this.current.sign(bs.getCompactData());
            bs = new ByteArrayBuffer();
            bs.putString(algo);
            bs.putBytes(sig);
            buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
            this.session.writePacket(buffer);
            return true;
        }
        throw new IllegalStateException("Received unknown packet: cmd=" + cmd);
    }

    @Override
    public void destroy() {
        if (this.agent != null) {
            try {
                this.agent.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
            }
        }
    }

    static class KeyPairIdentity
    implements PublicKeyIdentity {
        private final KeyPair pair;
        private final FactoryManager manager;

        KeyPairIdentity(FactoryManager manager, KeyPair pair) {
            this.manager = manager;
            this.pair = pair;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.pair.getPublic();
        }

        @Override
        public byte[] sign(byte[] data) throws Exception {
            String keyType = KeyUtils.getKeyType(this.pair);
            Signature verif = ValidateUtils.checkNotNull(NamedFactory.Utils.create(this.manager.getSignatureFactories(), keyType), "No signer could be located for key type=%s", (Object)keyType);
            verif.initSigner(this.pair.getPrivate());
            verif.update(data, 0, data.length);
            return verif.sign();
        }
    }

    static class KeyAgentIdentity
    implements PublicKeyIdentity {
        private final SshAgent agent;
        private final PublicKey key;

        KeyAgentIdentity(SshAgent agent, PublicKey key) {
            this.agent = agent;
            this.key = key;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.key;
        }

        @Override
        public byte[] sign(byte[] data) throws Exception {
            return this.agent.sign(this.key, data);
        }
    }

    static interface PublicKeyIdentity {
        public PublicKey getPublicKey();

        public byte[] sign(byte[] var1) throws Exception;
    }
}

