/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.SttySupport;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class PtyCapableChannelSession
extends ChannelSession {
    public static final int DEFAULT_COLUMNS_COUNT = 80;
    public static final int DEFAULT_ROWS_COUNT = 24;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    public static final Map<PtyMode, Integer> DEFAULT_PTY_MODES = Collections.unmodifiableMap(new EnumMap<PtyMode, Integer>(PtyMode.class){
        private static final long serialVersionUID = 1L;
        {
            this.put(PtyMode.ISIG, 1);
            this.put(PtyMode.ICANON, 1);
            this.put(PtyMode.ECHO, 1);
            this.put(PtyMode.ECHOE, 1);
            this.put(PtyMode.ECHOK, 1);
            this.put(PtyMode.ECHONL, 0);
            this.put(PtyMode.NOFLSH, 0);
        }
    });
    private boolean agentForwarding;
    private boolean usePty;
    private String ptyType;
    private int ptyColumns = 80;
    private int ptyLines = 24;
    private int ptyWidth = 640;
    private int ptyHeight = 480;
    private Map<PtyMode, Integer> ptyModes = new EnumMap<PtyMode, Integer>(PtyMode.class);
    private final Map<String, String> env = new LinkedHashMap<String, String>();

    public PtyCapableChannelSession(boolean usePty) {
        this.usePty = usePty;
        this.ptyType = System.getenv("TERM");
        if (GenericUtils.isEmpty(this.ptyType)) {
            this.ptyType = "dummy";
        }
        this.ptyModes.putAll(DEFAULT_PTY_MODES);
    }

    public void setupSensibleDefaultPty() {
        try {
            if (OsUtils.isUNIX()) {
                this.ptyModes = SttySupport.getUnixPtyModes();
                this.ptyColumns = SttySupport.getTerminalWidth();
                this.ptyLines = SttySupport.getTerminalHeight();
            } else {
                this.ptyType = "windows";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAgentForwarding() {
        return this.agentForwarding;
    }

    public void setAgentForwarding(boolean agentForwarding) {
        this.agentForwarding = agentForwarding;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    public void setUsePty(boolean usePty) {
        this.usePty = usePty;
    }

    public String getPtyType() {
        return this.ptyType;
    }

    public void setPtyType(String ptyType) {
        this.ptyType = ptyType;
    }

    public int getPtyColumns() {
        return this.ptyColumns;
    }

    public void setPtyColumns(int ptyColumns) {
        this.ptyColumns = ptyColumns;
    }

    public int getPtyLines() {
        return this.ptyLines;
    }

    public void setPtyLines(int ptyLines) {
        this.ptyLines = ptyLines;
    }

    public int getPtyWidth() {
        return this.ptyWidth;
    }

    public void setPtyWidth(int ptyWidth) {
        this.ptyWidth = ptyWidth;
    }

    public int getPtyHeight() {
        return this.ptyHeight;
    }

    public void setPtyHeight(int ptyHeight) {
        this.ptyHeight = ptyHeight;
    }

    public Map<PtyMode, Integer> getPtyModes() {
        return this.ptyModes;
    }

    public void setPtyModes(Map<PtyMode, Integer> ptyModes) {
        this.ptyModes = ptyModes == null ? Collections.emptyMap() : ptyModes;
    }

    public void setEnv(String key, String value) {
        this.env.put(key, value);
    }

    public void sendWindowChange(int columns, int lines, int height, int width) throws IOException {
        this.ptyColumns = columns;
        this.ptyLines = lines;
        this.ptyHeight = height;
        this.ptyWidth = width;
        Buffer buffer = this.session.createBuffer((byte)98);
        buffer.putInt(this.recipient);
        buffer.putString("window-change");
        buffer.putInt(this.ptyColumns);
        buffer.putInt(this.ptyLines);
        buffer.putInt(this.ptyHeight);
        buffer.putInt(this.ptyWidth);
        this.writePacket(buffer);
    }

    protected void doOpenPty() throws IOException {
        Buffer buffer;
        if (this.agentForwarding) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send agent forwarding request - recipient={}", (Object)this.recipient);
            }
            buffer = this.session.createBuffer((byte)98);
            buffer.putInt(this.recipient);
            buffer.putString("auth-agent-req@openssh.com");
            buffer.putBoolean(false);
            this.writePacket(buffer);
        }
        if (this.usePty) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send SSH_MSG_CHANNEL_REQUEST pty-req: type={}, cols={}, lines={}, height={}, width={}, modes={}", new Object[]{this.ptyType, this.ptyColumns, this.ptyLines, this.ptyHeight, this.ptyWidth, this.ptyModes});
            }
            buffer = this.session.createBuffer((byte)98);
            buffer.putInt(this.recipient);
            buffer.putString("pty-req");
            buffer.putBoolean(false);
            buffer.putString(this.ptyType);
            buffer.putInt(this.ptyColumns);
            buffer.putInt(this.ptyLines);
            buffer.putInt(this.ptyHeight);
            buffer.putInt(this.ptyWidth);
            ByteArrayBuffer modes = new ByteArrayBuffer(GenericUtils.size(this.ptyModes) * 5 + 8);
            for (Map.Entry<PtyMode, Integer> modeEntry : this.ptyModes.entrySet()) {
                PtyMode mode = modeEntry.getKey();
                Number value = modeEntry.getValue();
                ((Buffer)modes).putByte((byte)mode.toInt());
                modes.putInt(value.longValue());
            }
            ((Buffer)modes).putByte((byte)0);
            buffer.putBytes(modes.getCompactData());
            this.writePacket(buffer);
        }
        if (GenericUtils.size(this.env) > 0) {
            this.log.debug("Send SSH_MSG_CHANNEL_REQUEST env: {}", this.env);
            for (Map.Entry<String, String> entry : this.env.entrySet()) {
                buffer = this.session.createBuffer((byte)98);
                buffer.putInt(this.recipient);
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(entry.getKey());
                buffer.putString(entry.getValue());
                this.writePacket(buffer);
            }
        }
    }
}

