/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultConnectFuture
extends DefaultSshFuture<ConnectFuture>
implements ConnectFuture {
    public DefaultConnectFuture(Object lock) {
        super(lock);
    }

    @Override
    public ConnectFuture verify(long count, TimeUnit unit) throws IOException {
        return this.verify(unit.toMillis(count));
    }

    @Override
    public ConnectFuture verify(long timeout) throws IOException {
        long startTime = System.nanoTime();
        ClientSession session = this.verifyResult(ClientSession.class, timeout);
        long endTime = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            IoSession ioSession = session.getIoSession();
            this.log.debug("Connected to " + ioSession.getRemoteAddress() + " after " + (endTime - startTime) + " nanos");
        }
        return this;
    }

    @Override
    public ClientSession getSession() {
        Object v = this.getValue();
        if (v instanceof RuntimeException) {
            throw (RuntimeException)v;
        }
        if (v instanceof Error) {
            throw (Error)v;
        }
        if (v instanceof Throwable) {
            throw (RuntimeSshException)new RuntimeSshException("Failed to get the session.").initCause((Throwable)v);
        }
        if (v instanceof ClientSession) {
            return (ClientSession)v;
        }
        return null;
    }

    @Override
    public Throwable getException() {
        Object v = this.getValue();
        if (v instanceof Throwable) {
            return (Throwable)v;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.getValue() instanceof ClientSession;
    }

    @Override
    public void setSession(ClientSession session) {
        ValidateUtils.checkNotNull(session, "No client session provided");
        this.setValue(session);
    }

    @Override
    public void setException(Throwable exception) {
        ValidateUtils.checkNotNull(exception, "No exception provided");
        this.setValue(exception);
    }
}

