/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import org.apache.sshd.client.kex.AbstractDHClientKeyExchange;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class DHGClient
extends AbstractDHClientKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGClient(DHFactory factory) {
        this.factory = ValidateUtils.checkNotNull(factory, "No factory");
    }

    public static final KeyExchangeFactory newFactory(final DHFactory delegate) {
        return new KeyExchangeFactory(){

            @Override
            public String getName() {
                return delegate.getName();
            }

            @Override
            public KeyExchange create() {
                return new DHGClient(delegate);
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">" + "[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(AbstractSession s, byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(s, v_s, v_c, i_s, i_c);
        this.dh = this.getDH();
        this.hash = this.dh.getHash();
        this.hash.init();
        this.e = this.dh.getE();
        this.log.debug("Send SSH_MSG_KEXDH_INIT");
        Buffer buffer = s.createBuffer((byte)30);
        buffer.putMPInt(this.e);
        s.writePacket(buffer);
    }

    protected AbstractDH getDH() throws Exception {
        return this.factory.create(new Object[0]);
    }

    @Override
    public boolean next(Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        if (cmd != 31) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_REPLY, got " + cmd);
        }
        this.log.debug("Received SSH_MSG_KEXDH_REPLY");
        byte[] k_s = buffer.getBytes();
        this.f = buffer.getMPIntAsBytes();
        byte[] sig = buffer.getBytes();
        this.dh.setF(this.f);
        this.k = this.dh.getK();
        buffer = new ByteArrayBuffer(k_s);
        this.serverKey = buffer.getRawPublicKey();
        String keyAlg = KeyUtils.getKeyType(this.serverKey);
        if (GenericUtils.isEmpty(keyAlg)) {
            throw new SshException("Unsupported server key type");
        }
        buffer = new ByteArrayBuffer();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        buffer.putMPInt(this.e);
        buffer.putMPInt(this.f);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        AbstractSession session = this.getSession();
        FactoryManager manager = session.getFactoryManager();
        Signature verif = ValidateUtils.checkNotNull(NamedFactory.Utils.create(manager.getSignatureFactories(), keyAlg), "No verifier located for algorithm=%s", (Object)keyAlg);
        verif.initVerifier(this.serverKey);
        verif.update(this.h);
        if (!verif.verify(sig)) {
            throw new SshException(3, "KeyExchange signature verification failed");
        }
        return true;
    }
}

