/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.scp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.scp.AbstractScpClient;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.util.MockFileSystem;
import org.apache.sshd.common.file.util.MockPath;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpSourceStreamResolver;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultScpClient
extends AbstractScpClient {
    private final ClientSession clientSession;
    private final ScpTransferEventListener listener;

    public DefaultScpClient(ClientSession clientSession) {
        this(clientSession, ScpTransferEventListener.EMPTY);
    }

    public DefaultScpClient(ClientSession clientSession, ScpTransferEventListener eventListener) {
        this.clientSession = clientSession;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String remote, String local, Collection<ScpClient.Option> options) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", (Object)local);
        ClientFactoryManager manager = this.clientSession.getFactoryManager();
        FileSystemFactory factory = manager.getFileSystemFactory();
        FileSystem fs = factory.createFileSystem(this.clientSession);
        try {
            this.download(remote, fs, fs.getPath(local, new String[0]), options);
        }
        finally {
            try {
                fs.close();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String remote, OutputStream local) throws IOException {
        String cmd = DefaultScpClient.createReceiveCommand(remote, Collections.emptyList());
        ChannelExec channel = this.openCommandChannel(this.clientSession, cmd);
        try {
            ScpHelper helper = new ScpHelper(channel.getInvertedOut(), channel.getInvertedIn(), new MockFileSystem(remote), this.listener);
            helper.receiveFileStream(local, 8192);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void download(String remote, FileSystem fs, Path local, Collection<ScpClient.Option> options) throws IOException {
        String cmd = DefaultScpClient.createReceiveCommand(remote, options);
        ChannelExec channel = this.openCommandChannel(this.clientSession, cmd);
        try {
            ScpHelper helper = new ScpHelper(channel.getInvertedOut(), channel.getInvertedIn(), fs, this.listener);
            helper.receive(local, options.contains((Object)ScpClient.Option.Recursive), options.contains((Object)ScpClient.Option.TargetIsDirectory), options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(InputStream local, String remote, long size, Collection<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        int namePos = ValidateUtils.checkNotNullAndNotEmpty(remote, "No remote location specified").lastIndexOf(47);
        String name = namePos < 0 ? remote : ValidateUtils.checkNotNullAndNotEmpty(remote.substring(namePos + 1), "No name value in remote=%s", (Object)remote);
        String cmd = DefaultScpClient.createSendCommand(remote, time != null ? EnumSet.of(ScpClient.Option.PreserveAttributes) : Collections.emptySet());
        ChannelExec channel = this.openCommandChannel(this.clientSession, cmd);
        try {
            ScpHelper helper = new ScpHelper(channel.getInvertedOut(), channel.getInvertedIn(), new MockFileSystem(remote), this.listener);
            MockPath mockPath = new MockPath(remote);
            helper.sendStream(new StreamResolver(name, mockPath, perms, time, size, local, cmd), time != null, 8192);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> void runUpload(String remote, Collection<ScpClient.Option> options, Collection<T> local, AbstractScpClient.ScpOperationExecutor<T> executor) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", local);
        remote = ValidateUtils.checkNotNullAndNotEmpty(remote, "Invalid argument remote: %s", (Object)remote);
        if (local.size() > 1) {
            options = this.addTargetIsDirectory(options);
        }
        String cmd = DefaultScpClient.createSendCommand(remote, options);
        ChannelExec channel = this.openCommandChannel(this.clientSession, cmd);
        try {
            ClientFactoryManager manager = this.clientSession.getFactoryManager();
            FileSystemFactory factory = manager.getFileSystemFactory();
            FileSystem fs = factory.createFileSystem(this.clientSession);
            try {
                ScpHelper helper = new ScpHelper(channel.getInvertedOut(), channel.getInvertedIn(), fs, this.listener);
                executor.execute(helper, local, options);
            }
            finally {
                try {
                    fs.close();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        finally {
            channel.close(false);
        }
    }

    private static class StreamResolver
    implements ScpSourceStreamResolver {
        private final String name;
        private final Path mockPath;
        private final Collection<PosixFilePermission> perms;
        private final ScpTimestamp time;
        private final long size;
        private final InputStream local;
        private final String cmd;

        public StreamResolver(String name, Path mockPath, Collection<PosixFilePermission> perms, ScpTimestamp time, long size, InputStream local, String cmd) {
            this.name = name;
            this.mockPath = mockPath;
            this.perms = perms;
            this.time = time;
            this.size = size;
            this.local = local;
            this.cmd = cmd;
        }

        @Override
        public String getFileName() throws IOException {
            return this.name;
        }

        @Override
        public Path getEventListenerFilePath() {
            return this.mockPath;
        }

        @Override
        public Collection<PosixFilePermission> getPermissions() throws IOException {
            return this.perms;
        }

        @Override
        public ScpTimestamp getTimestamp() throws IOException {
            return this.time;
        }

        @Override
        public long getSize() throws IOException {
            return this.size;
        }

        @Override
        public InputStream resolveSourceStream() throws IOException {
            return this.local;
        }

        public String toString() {
            return this.cmd;
        }
    }
}

