/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.subsystem.SubsystemClient;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtension;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.bouncycastle.util.Arrays;

public interface SftpClient
extends SubsystemClient {
    public static final int MIN_BUFFER_SIZE = 127;
    public static final int MIN_READ_BUFFER_SIZE = 127;
    public static final int MIN_WRITE_BUFFER_SIZE = 127;
    public static final int IO_BUFFER_SIZE = 32768;
    public static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    public static final long DEFAULT_WAIT_TIMEOUT;
    public static final String SFTP_CHANNEL_OPEN_TIMEOUT = "sftp-channel-open-timeout";
    public static final long DEFAULT_CHANNEL_OPEN_TIMEOUT;

    public int getVersion();

    public Map<String, byte[]> getServerExtensions();

    public boolean isClosing();

    public CloseableHandle open(String var1) throws IOException;

    public CloseableHandle open(String var1, OpenMode ... var2) throws IOException;

    public CloseableHandle open(String var1, Collection<OpenMode> var2) throws IOException;

    public void close(Handle var1) throws IOException;

    public void remove(String var1) throws IOException;

    public void rename(String var1, String var2) throws IOException;

    public void rename(String var1, String var2, CopyMode ... var3) throws IOException;

    public void rename(String var1, String var2, Collection<CopyMode> var3) throws IOException;

    public int read(Handle var1, long var2, byte[] var4) throws IOException;

    public int read(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public void write(Handle var1, long var2, byte[] var4) throws IOException;

    public void write(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public void mkdir(String var1) throws IOException;

    public void rmdir(String var1) throws IOException;

    public CloseableHandle openDir(String var1) throws IOException;

    public List<DirEntry> readDir(Handle var1) throws IOException;

    public String canonicalPath(String var1) throws IOException;

    public Attributes stat(String var1) throws IOException;

    public Attributes lstat(String var1) throws IOException;

    public Attributes stat(Handle var1) throws IOException;

    public void setStat(String var1, Attributes var2) throws IOException;

    public void setStat(Handle var1, Attributes var2) throws IOException;

    public String readLink(String var1) throws IOException;

    public void symLink(String var1, String var2) throws IOException;

    public void link(String var1, String var2, boolean var3) throws IOException;

    public void lock(Handle var1, long var2, long var4, int var6) throws IOException;

    public void unlock(Handle var1, long var2, long var4) throws IOException;

    public Iterable<DirEntry> readDir(String var1) throws IOException;

    public InputStream read(String var1) throws IOException;

    public InputStream read(String var1, int var2) throws IOException;

    public InputStream read(String var1, OpenMode ... var2) throws IOException;

    public InputStream read(String var1, int var2, OpenMode ... var3) throws IOException;

    public InputStream read(String var1, Collection<OpenMode> var2) throws IOException;

    public InputStream read(String var1, int var2, Collection<OpenMode> var3) throws IOException;

    public OutputStream write(String var1) throws IOException;

    public OutputStream write(String var1, int var2) throws IOException;

    public OutputStream write(String var1, OpenMode ... var2) throws IOException;

    public OutputStream write(String var1, int var2, OpenMode ... var3) throws IOException;

    public OutputStream write(String var1, Collection<OpenMode> var2) throws IOException;

    public OutputStream write(String var1, int var2, Collection<OpenMode> var3) throws IOException;

    public <E extends SftpClientExtension> E getExtension(Class<? extends E> var1);

    public SftpClientExtension getExtension(String var1);

    static {
        DEFAULT_CHANNEL_OPEN_TIMEOUT = DEFAULT_WAIT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    }

    public static class DirEntry {
        public String filename;
        public String longFilename;
        public Attributes attributes;

        public DirEntry(String filename, String longFilename, Attributes attributes) {
            this.filename = filename;
            this.longFilename = longFilename;
            this.attributes = attributes;
        }
    }

    public static class Attributes {
        public final Set<Attribute> flags = EnumSet.noneOf(Attribute.class);
        public long size;
        public int type;
        public int uid;
        public int gid;
        public int perms;
        public int atime;
        public int ctime;
        public int mtime;
        public String owner;
        public String group;
        public FileTime accessTime;
        public FileTime createTime;
        public FileTime modifyTime;

        public String toString() {
            return "type=" + this.type + ";size=" + this.size + ";uid=" + this.uid + ";gid=" + this.gid + ";perms=0x" + Integer.toHexString(this.perms) + ";flags=" + this.flags + ";owner=" + this.owner + ";group=" + this.group + ";aTime=(" + this.atime + ")[" + this.accessTime + "]" + ";cTime=(" + this.ctime + ")[" + this.createTime + "]" + ";mTime=(" + this.mtime + ")[" + this.modifyTime + "]";
        }

        public Attributes size(long size) {
            this.flags.add(Attribute.Size);
            this.size = size;
            return this;
        }

        public Attributes owner(String owner) {
            this.flags.add(Attribute.OwnerGroup);
            this.owner = owner;
            if (GenericUtils.isEmpty(this.group)) {
                this.group = "GROUP@";
            }
            return this;
        }

        public Attributes group(String group) {
            this.flags.add(Attribute.OwnerGroup);
            this.group = group;
            if (GenericUtils.isEmpty(this.owner)) {
                this.owner = "OWNER@";
            }
            return this;
        }

        public Attributes owner(int uid, int gid) {
            this.flags.add(Attribute.UidGid);
            this.uid = uid;
            this.gid = gid;
            return this;
        }

        public Attributes perms(int perms) {
            this.flags.add(Attribute.Perms);
            this.perms = perms;
            return this;
        }

        public Attributes atime(int atime) {
            this.flags.add(Attribute.AccessTime);
            this.atime = atime;
            this.accessTime = FileTime.from(atime, TimeUnit.SECONDS);
            return this;
        }

        public Attributes ctime(int ctime) {
            this.flags.add(Attribute.CreateTime);
            this.ctime = ctime;
            this.createTime = FileTime.from(this.atime, TimeUnit.SECONDS);
            return this;
        }

        public Attributes mtime(int mtime) {
            this.flags.add(Attribute.ModifyTime);
            this.mtime = mtime;
            this.modifyTime = FileTime.from(this.atime, TimeUnit.SECONDS);
            return this;
        }

        public Attributes time(int atime, int mtime) {
            this.flags.add(Attribute.AcModTime);
            this.atime = atime;
            this.mtime = mtime;
            return this;
        }

        public Attributes accessTime(FileTime atime) {
            this.flags.add(Attribute.AccessTime);
            this.atime = (int)atime.to(TimeUnit.SECONDS);
            this.accessTime = atime;
            return this;
        }

        public Attributes createTime(FileTime ctime) {
            this.flags.add(Attribute.CreateTime);
            this.ctime = (int)ctime.to(TimeUnit.SECONDS);
            this.createTime = ctime;
            return this;
        }

        public Attributes modifyTime(FileTime mtime) {
            this.flags.add(Attribute.ModifyTime);
            this.mtime = (int)mtime.to(TimeUnit.SECONDS);
            this.modifyTime = mtime;
            return this;
        }

        public boolean isRegularFile() {
            return (this.perms & 0xF000) == 32768;
        }

        public boolean isDirectory() {
            return (this.perms & 0xF000) == 16384;
        }

        public boolean isSymbolicLink() {
            return (this.perms & 0xF000) == 40960;
        }

        public boolean isOther() {
            return !this.isRegularFile() && !this.isDirectory() && !this.isSymbolicLink();
        }
    }

    public static abstract class CloseableHandle
    extends Handle
    implements Channel,
    Closeable {
        protected CloseableHandle(byte[] id) {
            super(id);
        }
    }

    public static class Handle {
        private final byte[] id;

        public Handle(byte[] id) {
            this.id = (byte[])ValidateUtils.checkNotNullAndNotEmpty(id, "No handle ID", new Object[0]).clone();
        }

        public int length() {
            return this.id.length;
        }

        public byte[] getIdentifier() {
            return (byte[])this.id.clone();
        }

        public int hashCode() {
            return Arrays.hashCode((byte[])this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Handle)) {
                return false;
            }
            return Arrays.areEqual((byte[])this.id, (byte[])((Handle)obj).id);
        }

        public String toString() {
            return BufferUtils.printHex('\u0000', this.id);
        }
    }

    public static enum Attribute {
        Size,
        UidGid,
        Perms,
        AcModTime,
        OwnerGroup,
        AccessTime,
        ModifyTime,
        CreateTime;

    }

    public static enum CopyMode {
        Atomic,
        Overwrite;

    }

    public static enum OpenMode {
        Read,
        Write,
        Append,
        Create,
        Truncate,
        Exclusive;

    }
}

