/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.nio.channels.Channel;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SftpDirEntryIterator
extends AbstractLoggingBean
implements Iterator<SftpClient.DirEntry>,
Channel {
    private final SftpClient client;
    private final String dirPath;
    private SftpClient.CloseableHandle dirHandle;
    private List<SftpClient.DirEntry> dirEntries;
    private int index;

    public SftpDirEntryIterator(SftpClient client, String path) {
        this.client = ValidateUtils.checkNotNull(client, "No SFTP client instance");
        this.dirPath = path;
        this.dirHandle = this.open(path);
        this.dirEntries = this.load(this.dirHandle);
    }

    public final SftpClient getClient() {
        return this.client;
    }

    public final String getPath() {
        return this.dirPath;
    }

    @Override
    public boolean hasNext() {
        return this.dirEntries != null && this.index < this.dirEntries.size();
    }

    @Override
    public SftpClient.DirEntry next() {
        SftpClient.DirEntry entry = this.dirEntries.get(this.index++);
        if (this.index >= this.dirEntries.size()) {
            this.index = 0;
            try {
                this.dirEntries = this.load(this.dirHandle);
            }
            catch (RuntimeException e) {
                this.dirEntries = null;
                throw e;
            }
        }
        return entry;
    }

    @Override
    public boolean isOpen() {
        return this.dirHandle != null && this.dirHandle.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("close(" + this.getPath() + ") handle=" + this.dirHandle);
            }
            this.dirHandle.close();
        }
    }

    protected SftpClient.CloseableHandle open(String path) {
        try {
            SftpClient.CloseableHandle handle = this.client.openDir(path);
            if (this.log.isDebugEnabled()) {
                this.log.debug("open(" + path + ") handle=" + handle);
            }
            return handle;
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("open(" + path + ") failed (" + e.getClass().getSimpleName() + ") to open dir: " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    protected List<SftpClient.DirEntry> load(SftpClient.CloseableHandle handle) {
        try {
            List<SftpClient.DirEntry> entries = this.client.readDir(handle);
            if (entries == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("load(" + this.getPath() + ") exhausted all entries");
                }
                this.close();
            }
            return entries;
        }
        catch (IOException e) {
            block6: {
                try {
                    this.close();
                }
                catch (IOException t) {
                    if (!this.log.isTraceEnabled()) break block6;
                    this.log.trace(t.getClass().getSimpleName() + " while close handle=" + handle + " due to " + e.getClass().getSimpleName() + " [" + e.getMessage() + "]" + ": " + t.getMessage());
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("readDir(" + this.getPath() + ") Iterator#remove() N/A");
    }
}

