/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpDirectoryStream;
import org.apache.sshd.client.subsystem.sftp.SftpException;
import org.apache.sshd.client.subsystem.sftp.SftpFileChannel;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.SftpPath;
import org.apache.sshd.client.subsystem.sftp.SftpPosixFileAttributeView;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileSystemProvider
extends FileSystemProvider {
    public static final String READ_BUFFER_PROP_NAME = "sftp-fs-read-buffer-size";
    public static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    public static final String WRITE_BUFFER_PROP_NAME = "sftp-fs-write-buffer-size";
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    public static final String CONNECT_TIME_PROP_NAME = "sftp-fs-connect-time";
    public static final long DEFAULT_CONNECT_TIME = SftpClient.DEFAULT_WAIT_TIMEOUT;
    public static final String AUTH_TIME_PROP_NAME = "sftp-fs-auth-time";
    public static final long DEFAULT_AUTH_TIME = SftpClient.DEFAULT_WAIT_TIMEOUT;
    public static final Set<Class<? extends FileAttributeView>> SUPPORTED_VIEWS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(BasicFileAttributeView.class, PosixFileAttributeView.class)));
    protected final Logger log;
    private final SshClient client;
    private final SftpVersionSelector selector;
    private final Map<String, SftpFileSystem> fileSystems = new HashMap<String, SftpFileSystem>();

    public SftpFileSystemProvider() {
        this((SshClient)null);
    }

    public SftpFileSystemProvider(SftpVersionSelector selector) {
        this(null, selector);
    }

    public SftpFileSystemProvider(SshClient client) {
        this(client, SftpVersionSelector.CURRENT);
    }

    public SftpFileSystemProvider(SshClient client, SftpVersionSelector selector) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.selector = ValidateUtils.checkNotNull(selector, "No SFTP version selector provided");
        if (client == null) {
            client = SshClient.setUpDefaultClient();
            client.start();
        }
        this.client = client;
    }

    @Override
    public String getScheme() {
        return "sftp";
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SftpFileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        SftpFileSystem fileSystem;
        String userInfo;
        String[] ui;
        String host = ValidateUtils.checkNotNullAndNotEmpty(uri.getHost(), "Host not provided");
        int port = uri.getPort();
        if (port <= 0) {
            port = 22;
        }
        ValidateUtils.checkTrue(GenericUtils.length(ui = GenericUtils.split(userInfo = ValidateUtils.checkNotNullAndNotEmpty(uri.getUserInfo(), "UserInfo not provided"), ':')) == 2, "Invalid user info: %s", (Object)userInfo);
        String username = ui[0];
        String password = ui[1];
        String id = SftpFileSystemProvider.getFileSystemIdentifier(host, port, username);
        Map<String, SftpFileSystem> map = this.fileSystems;
        synchronized (map) {
            if (this.fileSystems.containsKey(id)) {
                throw new FileSystemAlreadyExistsException(id);
            }
            Channel session = null;
            try {
                session = this.client.connect(username, host, port).verify(FactoryManagerUtils.getLongProperty(env, CONNECT_TIME_PROP_NAME, DEFAULT_CONNECT_TIME)).getSession();
                session.addPasswordIdentity(password);
                session.auth().verify(FactoryManagerUtils.getLongProperty(env, AUTH_TIME_PROP_NAME, DEFAULT_AUTH_TIME));
                fileSystem = new SftpFileSystem(this, id, (ClientSession)session, this.getSftpVersionSelector());
                this.fileSystems.put(id, fileSystem);
            }
            catch (Exception e) {
                block12: {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (IOException t) {
                            if (!this.log.isDebugEnabled()) break block12;
                            this.log.debug("Failed (" + t.getClass().getSimpleName() + ")" + " to close session for new file system on " + host + ":" + port + " due to " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]" + ": " + t.getMessage());
                        }
                    }
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IOException(e);
            }
        }
        fileSystem.setReadBufferSize(FactoryManagerUtils.getIntProperty(env, READ_BUFFER_PROP_NAME, 32768));
        fileSystem.setWriteBufferSize(FactoryManagerUtils.getIntProperty(env, WRITE_BUFFER_PROP_NAME, 32768));
        return fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem newFileSystem(ClientSession session) throws IOException {
        SftpFileSystem fileSystem;
        String id = SftpFileSystemProvider.getFileSystemIdentifier(session);
        Map<String, SftpFileSystem> map = this.fileSystems;
        synchronized (map) {
            if (this.fileSystems.containsKey(id)) {
                throw new FileSystemAlreadyExistsException(id);
            }
            fileSystem = new SftpFileSystem(this, id, session, this.getSftpVersionSelector());
            this.fileSystems.put(id, fileSystem);
        }
        ClientFactoryManager manager = session.getFactoryManager();
        fileSystem.setReadBufferSize(FactoryManagerUtils.getIntProperty(manager, READ_BUFFER_PROP_NAME, 32768));
        fileSystem.setWriteBufferSize(FactoryManagerUtils.getIntProperty(manager, WRITE_BUFFER_PROP_NAME, 32768));
        return fileSystem;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String id = SftpFileSystemProvider.getFileSystemIdentifier(uri);
        SftpFileSystem fs = this.getFileSystem(id);
        if (fs == null) {
            throw new FileSystemNotFoundException(id);
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem removeFileSystem(String id) {
        if (GenericUtils.isEmpty(id)) {
            return null;
        }
        Map<String, SftpFileSystem> map = this.fileSystems;
        synchronized (map) {
            return this.fileSystems.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem getFileSystem(String id) {
        if (GenericUtils.isEmpty(id)) {
            return null;
        }
        Map<String, SftpFileSystem> map = this.fileSystems;
        synchronized (map) {
            return this.fileSystems.get(id);
        }
    }

    @Override
    public Path getPath(URI uri) {
        FileSystem fs = this.getFileSystem(uri);
        return fs.getPath(uri.getPath(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(path, options, attrs);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        EnumSet<SftpClient.OpenMode> modes = EnumSet.noneOf(SftpClient.OpenMode.class);
        for (OpenOption openOption : options) {
            if (openOption == StandardOpenOption.READ) {
                modes.add(SftpClient.OpenMode.Read);
                continue;
            }
            if (openOption == StandardOpenOption.APPEND) {
                modes.add(SftpClient.OpenMode.Append);
                continue;
            }
            if (openOption == StandardOpenOption.CREATE) {
                modes.add(SftpClient.OpenMode.Create);
                continue;
            }
            if (openOption == StandardOpenOption.TRUNCATE_EXISTING) {
                modes.add(SftpClient.OpenMode.Truncate);
                continue;
            }
            if (openOption == StandardOpenOption.WRITE) {
                modes.add(SftpClient.OpenMode.Write);
                continue;
            }
            if (openOption == StandardOpenOption.CREATE_NEW) {
                modes.add(SftpClient.OpenMode.Create);
                modes.add(SftpClient.OpenMode.Exclusive);
                continue;
            }
            if (openOption == StandardOpenOption.SPARSE) continue;
            throw new IllegalArgumentException("newFileChannel(" + path + ") unsupported open option: " + openOption);
        }
        if (modes.isEmpty()) {
            modes.add(SftpClient.OpenMode.Read);
            modes.add(SftpClient.OpenMode.Write);
        }
        return new SftpFileChannel(this.toSftpPath(path), modes);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        SftpPath p = this.toSftpPath(dir);
        return new SftpDirectoryStream(p);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        SftpPath p = this.toSftpPath(dir);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        try (SftpClient sftp = fs.getClient();){
            try {
                sftp.mkdir(dir.toString());
            }
            catch (SftpException e) {
                int sftpStatus = e.getStatus();
                if (sftp.getVersion() == 3 && sftpStatus == 4) {
                    try {
                        SftpClient.Attributes attributes = sftp.stat(dir.toString());
                        if (attributes != null) {
                            throw new FileAlreadyExistsException(p.toString());
                        }
                    }
                    catch (SshException e2) {
                        e.addSuppressed(e2);
                    }
                }
                if (sftpStatus == 11) {
                    throw new FileAlreadyExistsException(p.toString());
                }
                throw e;
            }
            for (FileAttribute<?> attr : attrs) {
                this.setAttribute(p, attr.name(), attr.value(), new LinkOption[0]);
            }
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        SftpPath p = this.toSftpPath(path);
        this.checkAccess(p, AccessMode.WRITE);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        try (SftpClient sftp = fs.getClient();){
            BasicFileAttributes attributes = this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (attributes.isDirectory()) {
                sftp.rmdir(path.toString());
            } else {
                sftp.remove(path.toString());
            }
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        SftpPath src = this.toSftpPath(source);
        SftpPath dst = this.toSftpPath(target);
        if (src.getFileSystem() != dst.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + src + " vs. " + dst);
        }
        this.checkAccess(src, new AccessMode[0]);
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean noFollowLinks = false;
        for (CopyOption opt : options) {
            replaceExisting |= opt == StandardCopyOption.REPLACE_EXISTING;
            copyAttributes |= opt == StandardCopyOption.COPY_ATTRIBUTES;
            noFollowLinks |= opt == LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = IoUtils.getLinkOptions(!noFollowLinks);
        BasicFileAttributes attrs = this.readAttributes(source, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        Boolean status = IoUtils.checkFileExists(target, linkOptions);
        if (status == null) {
            throw new AccessDeniedException("Existence cannot be determined for copy target: " + target);
        }
        if (replaceExisting) {
            this.deleteIfExists(target);
        } else if (status.booleanValue()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (attrs.isDirectory()) {
            this.createDirectory(target, new FileAttribute[0]);
        } else {
            try (InputStream in = this.newInputStream(source, new OpenOption[0]);
                 OutputStream os = this.newOutputStream(target, new OpenOption[0]);){
                IoUtils.copy(in, os);
            }
        }
        if (copyAttributes) {
            BasicFileAttributeView view = this.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    this.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        SftpPath src = this.toSftpPath(source);
        SftpFileSystem fsSrc = (SftpFileSystem)src.getFileSystem();
        SftpPath dst = this.toSftpPath(target);
        if (src.getFileSystem() != dst.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + src + " vs. " + dst);
        }
        this.checkAccess(src, new AccessMode[0]);
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean noFollowLinks = false;
        for (CopyOption opt : options) {
            replaceExisting |= opt == StandardCopyOption.REPLACE_EXISTING;
            copyAttributes |= opt == StandardCopyOption.COPY_ATTRIBUTES;
            noFollowLinks |= opt == LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = IoUtils.getLinkOptions(noFollowLinks);
        BasicFileAttributes attrs = this.readAttributes(source, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Moving of source symbolic link not supported: " + source);
        }
        Boolean status = IoUtils.checkFileExists(target, linkOptions);
        if (status == null) {
            throw new AccessDeniedException("Existence cannot be determined for move target " + target);
        }
        if (replaceExisting) {
            this.deleteIfExists(target);
        } else if (status.booleanValue()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        try (SftpClient sftp = fsSrc.getClient();){
            sftp.rename(src.toString(), dst.toString());
        }
        if (copyAttributes) {
            BasicFileAttributeView view = this.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    this.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        SftpPath p1 = this.toSftpPath(path1);
        SftpPath p2 = this.toSftpPath(path2);
        if (p1.getFileSystem() != p2.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + p1 + " vs. " + p2);
        }
        this.checkAccess(p1, new AccessMode[0]);
        this.checkAccess(p2, new AccessMode[0]);
        return p1.equals(p2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        FileSystem fs = path.getFileSystem();
        if (!(fs instanceof SftpFileSystem)) {
            throw new FileSystemException(path.toString(), path.toString(), "getFileStore(" + path + ") path not attached to an SFTP file system");
        }
        SftpFileSystem sftpFs = (SftpFileSystem)fs;
        String id = sftpFs.getId();
        SftpFileSystem cached = this.getFileSystem(id);
        if (cached != sftpFs) {
            throw new FileSystemException(path.toString(), path.toString(), "Mismatched file system instance for id=" + id);
        }
        return (FileStore)sftpFs.getFileStores().get(0);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        SftpPath t;
        SftpPath l = this.toSftpPath(link);
        SftpFileSystem fsLink = (SftpFileSystem)l.getFileSystem();
        if (fsLink != (t = this.toSftpPath(target)).getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + l + " vs. " + t);
        }
        try (SftpClient client = fsLink.getClient();){
            client.symLink(l.toString(), t.toString());
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        SftpPath l = this.toSftpPath(link);
        SftpFileSystem fsLink = (SftpFileSystem)l.getFileSystem();
        try (SftpClient client = fsLink.getClient();){
            Object t = fsLink.getPath(client.readLink(l.toString()), new String[0]);
            return t;
        }
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        BasicFileAttributes attrs;
        SftpPath p = this.toSftpPath(path);
        boolean w = false;
        boolean x = false;
        if (GenericUtils.length(modes) > 0) {
            block5: for (AccessMode mode : modes) {
                switch (mode) {
                    case READ: {
                        continue block5;
                    }
                    case WRITE: {
                        w = true;
                        continue block5;
                    }
                    case EXECUTE: {
                        x = true;
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported mode: " + (Object)((Object)mode));
                    }
                }
            }
        }
        if (!((attrs = this.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes()) != null || p.isAbsolute() && p.getNameCount() == 0)) {
            throw new NoSuchFileException(path.toString());
        }
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (x || w && fs.isReadOnly()) {
            throw new AccessDeniedException("Filesystem is read-only: " + path.toString());
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (this.isSupportedFileAttributeView(type)) {
            return (V)((FileAttributeView)type.cast(new SftpPosixFileAttributeView(this, path, options)));
        }
        throw new UnsupportedOperationException("getFileAttributeView(" + path + ") view not supported: " + type.getSimpleName());
    }

    public boolean isSupportedFileAttributeView(Class<? extends FileAttributeView> type) {
        return type != null && SUPPORTED_VIEWS.contains(type);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type.isAssignableFrom(PosixFileAttributes.class)) {
            return (A)((BasicFileAttributes)type.cast(this.getFileAttributeView(path, PosixFileAttributeView.class, options).readAttributes()));
        }
        throw new UnsupportedOperationException("readAttributes(" + path + ")[" + type.getSimpleName() + "] N/A");
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        String attrs;
        String view;
        int i = attributes.indexOf(58);
        if (i == -1) {
            view = "basic";
            attrs = attributes;
        } else {
            view = attributes.substring(0, i++);
            attrs = attributes.substring(i);
        }
        SftpPath p = this.toSftpPath(path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (GenericUtils.isEmpty(views) || !views.contains(view)) {
            throw new UnsupportedOperationException("readAttributes(" + path + ")[" + attributes + "] view " + view + " not supported: " + views);
        }
        PosixFileAttributes v = this.readAttributes(path, PosixFileAttributes.class, options);
        if ("*".equals(attrs)) {
            attrs = "lastModifiedTime,lastAccessTime,creationTime,size,isRegularFile,isDirectory,isSymbolicLink,isOther,fileKey,owner,permissions,group";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] stringArray = attrs.split(",");
        int n = stringArray.length;
        block28: for (int j = 0; j < n; ++j) {
            String attr;
            switch (attr = stringArray[j]) {
                case "lastModifiedTime": {
                    map.put(attr, v.lastModifiedTime());
                    continue block28;
                }
                case "lastAccessTime": {
                    map.put(attr, v.lastAccessTime());
                    continue block28;
                }
                case "creationTime": {
                    map.put(attr, v.creationTime());
                    continue block28;
                }
                case "size": {
                    map.put(attr, v.size());
                    continue block28;
                }
                case "isRegularFile": {
                    map.put(attr, v.isRegularFile());
                    continue block28;
                }
                case "isDirectory": {
                    map.put(attr, v.isDirectory());
                    continue block28;
                }
                case "isSymbolicLink": {
                    map.put(attr, v.isSymbolicLink());
                    continue block28;
                }
                case "isOther": {
                    map.put(attr, v.isOther());
                    continue block28;
                }
                case "fileKey": {
                    map.put(attr, v.fileKey());
                    continue block28;
                }
                case "owner": {
                    map.put(attr, v.owner());
                    continue block28;
                }
                case "permissions": {
                    map.put(attr, v.permissions());
                    continue block28;
                }
                case "group": {
                    map.put(attr, v.group());
                    continue block28;
                }
                default: {
                    if (!this.log.isTraceEnabled()) continue block28;
                    this.log.trace("readAttributes({})[{}] ignored {}={}", new Object[]{path, attributes, attr, v});
                }
            }
        }
        return map;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        String attr;
        String view;
        int i = attribute.indexOf(58);
        if (i == -1) {
            view = "basic";
            attr = attribute;
        } else {
            view = attribute.substring(0, i++);
            attr = attribute.substring(i);
        }
        SftpPath p = this.toSftpPath(path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (GenericUtils.isEmpty(views) || !view.contains(view)) {
            throw new UnsupportedOperationException("setAttribute(" + path + ")[" + attribute + "=" + value + "] view " + view + " not supported: " + views);
        }
        SftpClient.Attributes attributes = new SftpClient.Attributes();
        switch (attr) {
            case "lastModifiedTime": {
                attributes.mtime((int)((FileTime)value).to(TimeUnit.SECONDS));
                break;
            }
            case "lastAccessTime": {
                attributes.atime((int)((FileTime)value).to(TimeUnit.SECONDS));
                break;
            }
            case "creationTime": {
                attributes.ctime((int)((FileTime)value).to(TimeUnit.SECONDS));
                break;
            }
            case "size": {
                attributes.size(((Number)value).longValue());
                break;
            }
            case "permissions": {
                Set attrSet = (Set)value;
                attributes.perms(this.attributesToPermissions(path, attrSet));
                break;
            }
            case "owner": {
                attributes.owner(((UserPrincipal)value).getName());
                break;
            }
            case "group": {
                attributes.group(((GroupPrincipal)value).getName());
                break;
            }
            case "isRegularFile": 
            case "isDirectory": 
            case "isSymbolicLink": 
            case "isOther": 
            case "fileKey": {
                throw new UnsupportedOperationException("setAttribute(" + path + ")[" + attribute + "=" + value + "]" + " unknown view=" + view + " attribute: " + attr);
            }
            default: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace("setAttribute({})[{}] ignore {}={}", new Object[]{path, attribute, attr, value});
            }
        }
        try (SftpClient client = fs.getClient();){
            client.setStat(p.toString(), attributes);
        }
    }

    protected SftpPath toSftpPath(Path path) {
        ValidateUtils.checkNotNull(path, "No path provided");
        if (!(path instanceof SftpPath)) {
            throw new ProviderMismatchException("Path is not SFTP: " + path);
        }
        return (SftpPath)path;
    }

    protected int attributesToPermissions(Path path, Collection<PosixFilePermission> perms) {
        if (GenericUtils.isEmpty(perms)) {
            return 0;
        }
        int pf = 0;
        block11: for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    continue block11;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    continue block11;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    continue block11;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    continue block11;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    continue block11;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    continue block11;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    continue block11;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    continue block11;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    continue block11;
                }
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("attributesToPermissions(" + path + ") ignored " + (Object)((Object)p));
        }
        return pf;
    }

    public static String getRWXPermissions(int perms) {
        StringBuilder sb = new StringBuilder(10);
        if ((perms & 0xA000) == 40960) {
            sb.append('l');
        } else if ((perms & 0x4000) == 16384) {
            sb.append('d');
        } else {
            sb.append('-');
        }
        if ((perms & 0x100) == 256) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 0x80) == 128) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 0x40) == 64) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        if ((perms & 0x20) == 32) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 0x10) == 16) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 8) == 8) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        if ((perms & 4) == 4) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 2) == 2) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 1) == 1) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getOctalPermissions(int perms) {
        return SftpFileSystemProvider.getOctalPermissions(SftpFileSystemProvider.permissionsToAttributes(perms));
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        HashSet<PosixFilePermission> p = new HashSet<PosixFilePermission>();
        if ((perms & 0x100) == 256) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) == 128) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) == 64) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) == 32) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) == 16) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) == 8) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) == 4) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) == 2) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) == 1) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static String getOctalPermissions(Collection<PosixFilePermission> perms) {
        int pf = 0;
        for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    break;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    break;
                }
            }
        }
        return String.format("%04o", pf);
    }

    public static String getFileSystemIdentifier(URI uri) {
        String userInfo = ValidateUtils.checkNotNullAndNotEmpty(uri.getUserInfo(), "UserInfo not provided");
        String[] ui = GenericUtils.split(userInfo, ':');
        ValidateUtils.checkTrue(GenericUtils.length(ui) == 2, "Invalid user info: %s", (Object)userInfo);
        return SftpFileSystemProvider.getFileSystemIdentifier(uri.getHost(), uri.getPort(), ui[0]);
    }

    public static String getFileSystemIdentifier(ClientSession session) {
        IoSession ioSession = session.getIoSession();
        SocketAddress addr = ioSession.getRemoteAddress();
        String username = session.getUsername();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress inetAddr = (InetSocketAddress)addr;
            return SftpFileSystemProvider.getFileSystemIdentifier(inetAddr.getHostString(), inetAddr.getPort(), username);
        }
        return SftpFileSystemProvider.getFileSystemIdentifier(addr.toString(), 22, username);
    }

    public static String getFileSystemIdentifier(String host, int port, String username) {
        return GenericUtils.trimToEmpty(host) + ':' + (port <= 0 ? 22 : port) + ':' + GenericUtils.trimToEmpty(username);
    }

    public static URI createFileSystemURI(String host, int port, String username, String password) {
        return URI.create("sftp://" + username + ":" + password + "@" + host + ":" + port + "/");
    }
}

