/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.util.Collection;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.OutputStreamWithChannel;

public class SftpOutputStreamWithChannel
extends OutputStreamWithChannel {
    private final SftpClient client;
    private final String path;
    private final byte[] bb = new byte[1];
    private final byte[] buffer;
    private int index;
    private SftpClient.CloseableHandle handle;
    private long offset;

    public SftpOutputStreamWithChannel(SftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.client = ValidateUtils.checkNotNull(client, "No SFTP client instance");
        this.path = path;
        this.buffer = new byte[bufferSize];
        this.handle = client.open(path, mode);
    }

    public final SftpClient getClient() {
        return this.client;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    @Override
    public void write(int b) throws IOException {
        this.bb[0] = (byte)b;
        this.write(this.bb, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int nb;
        if (!this.isOpen()) {
            throw new IOException("write(" + this.getPath() + ")[len=" + len + "] stream is closed");
        }
        do {
            nb = Math.min(len, this.buffer.length - this.index);
            System.arraycopy(b, off, this.buffer, this.index, nb);
            this.index += nb;
            if (this.index == this.buffer.length) {
                this.flush();
            }
            off += nb;
        } while ((len -= nb) > 0);
    }

    @Override
    public void flush() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("flush(" + this.getPath() + ") stream is closed");
        }
        this.client.write(this.handle, this.offset, this.buffer, 0, this.index);
        this.offset += (long)this.index;
        this.index = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            try {
                try {
                    if (this.index > 0) {
                        this.flush();
                    }
                }
                finally {
                    this.handle.close();
                }
            }
            finally {
                this.handle = null;
            }
        }
    }
}

