/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Map;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;

public final class FactoryManagerUtils {
    private FactoryManagerUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static long getLongProperty(Session session, String name, long defaultValue) {
        return FactoryManagerUtils.getLongProperty(session.getFactoryManager(), name, defaultValue);
    }

    public static long getLongProperty(FactoryManager manager, String name, long defaultValue) {
        return FactoryManagerUtils.getLongProperty(manager.getProperties(), name, defaultValue);
    }

    public static long getLongProperty(Map<String, ?> props, String name, long defaultValue) {
        Object value;
        Object object = value = GenericUtils.isEmpty(props) ? null : (Object)props.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    public static Long getLong(Session session, String name) {
        return FactoryManagerUtils.getLong(session.getFactoryManager(), name);
    }

    public static Long getLong(FactoryManager manager, String name) {
        return FactoryManagerUtils.getLong(manager.getProperties(), name);
    }

    public static Long getLong(Map<String, ?> props, String name) {
        Object value;
        Object object = value = GenericUtils.isEmpty(props) ? null : (Object)props.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.valueOf(value.toString());
    }

    public static Object updateProperty(Session session, String name, long value) {
        return FactoryManagerUtils.updateProperty(session, name, (Object)Long.toString(value));
    }

    public static Object updateProperty(FactoryManager manager, String name, long value) {
        return FactoryManagerUtils.updateProperty(manager.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, long value) {
        return FactoryManagerUtils.updateProperty(props, name, (Object)value);
    }

    public static int getIntProperty(Session session, String name, int defaultValue) {
        return FactoryManagerUtils.getIntProperty(session.getFactoryManager(), name, defaultValue);
    }

    public static int getIntProperty(FactoryManager manager, String name, int defaultValue) {
        return FactoryManagerUtils.getIntProperty(manager.getProperties(), name, defaultValue);
    }

    public static int getIntProperty(Map<String, ?> props, String name, int defaultValue) {
        Object value;
        Object object = value = GenericUtils.isEmpty(props) ? null : (Object)props.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    public static Integer getInteger(Session session, String name) {
        return FactoryManagerUtils.getInteger(session.getFactoryManager(), name);
    }

    public static Integer getInteger(FactoryManager manager, String name) {
        return FactoryManagerUtils.getInteger(manager.getProperties(), name);
    }

    public static Integer getInteger(Map<String, ?> props, String name) {
        Object value;
        Object object = value = GenericUtils.isEmpty(props) ? null : (Object)props.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf(value.toString());
    }

    public static Object updateProperty(Session session, String name, int value) {
        return FactoryManagerUtils.updateProperty(session.getFactoryManager(), name, value);
    }

    public static Object updateProperty(FactoryManager manager, String name, int value) {
        return FactoryManagerUtils.updateProperty(manager.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, int value) {
        return FactoryManagerUtils.updateProperty(props, name, (Object)value);
    }

    public static boolean getBooleanProperty(Session session, String name, boolean defaultValue) {
        return FactoryManagerUtils.getBooleanProperty(session.getFactoryManager(), name, defaultValue);
    }

    public static boolean getBooleanProperty(FactoryManager manager, String name, boolean defaultValue) {
        return FactoryManagerUtils.getBooleanProperty(manager.getProperties(), name, defaultValue);
    }

    public static boolean getBooleanProperty(Map<String, ?> props, String name, boolean defaultValue) {
        Boolean value = FactoryManagerUtils.getBoolean(props, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Boolean getBoolean(Session session, String name) {
        return FactoryManagerUtils.getBoolean(session.getFactoryManager(), name);
    }

    public static Boolean getBoolean(FactoryManager manager, String name) {
        return FactoryManagerUtils.getBoolean(manager.getProperties(), name);
    }

    public static Boolean getBoolean(Map<String, ?> props, String name) {
        Object value;
        Object object = value = GenericUtils.isEmpty(props) ? null : (Object)props.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public static Object updateProperty(Session session, String name, boolean value) {
        return FactoryManagerUtils.updateProperty(session.getFactoryManager(), name, value);
    }

    public static Object updateProperty(FactoryManager manager, String name, boolean value) {
        return FactoryManagerUtils.updateProperty(manager.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, boolean value) {
        return FactoryManagerUtils.updateProperty(props, name, (Object)value);
    }

    public static String getString(Session session, String name) {
        return FactoryManagerUtils.getStringProperty(session, name, null);
    }

    public static String getStringProperty(Session session, String name, String defaultValue) {
        return FactoryManagerUtils.getStringProperty(session.getFactoryManager(), name, defaultValue);
    }

    public static String getString(FactoryManager manager, String name) {
        return FactoryManagerUtils.getStringProperty(manager, name, null);
    }

    public static String getStringProperty(FactoryManager manager, String name, String defaultValue) {
        return FactoryManagerUtils.getStringProperty(manager.getProperties(), name, defaultValue);
    }

    public static String getString(Map<String, ?> props, String name) {
        return FactoryManagerUtils.getStringProperty(props, name, null);
    }

    public static String getStringProperty(Map<String, ?> props, String name, String defaultValue) {
        String s;
        Object value = GenericUtils.isEmpty(props) ? null : (Object)props.get(name);
        String string = s = value == null ? null : value.toString();
        if (GenericUtils.isEmpty(s)) {
            return defaultValue;
        }
        return s;
    }

    public static Object updateProperty(Session session, String name, Object value) {
        return FactoryManagerUtils.updateProperty(session.getFactoryManager(), name, value);
    }

    public static Object updateProperty(FactoryManager manager, String name, Object value) {
        return FactoryManagerUtils.updateProperty(manager.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, Object value) {
        if (value == null || value instanceof CharSequence && GenericUtils.isEmpty((CharSequence)value)) {
            return props.remove(name);
        }
        return props.put(name, value);
    }
}

