/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;

public abstract class AbstractChannel
extends CloseableUtils.AbstractInnerCloseable
implements Channel,
ExecutorServiceConfigurer {
    public static final int DEFAULT_WINDOW_SIZE = 0x200000;
    public static final int DEFAULT_PACKET_SIZE = 32768;
    public static final long DEFAULT_CHANNEL_CLOSE_TIMEOUT = 5000L;
    public static final Int2IntFunction RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.Utils.add(8);
    protected ExecutorService executor;
    protected boolean shutdownExecutor;
    protected final Window localWindow = new Window(this, null, this.getClass().getName().contains(".client."), true);
    protected final Window remoteWindow = new Window(this, null, this.getClass().getName().contains(".client."), false);
    protected ConnectionService service;
    protected Session session;
    protected int id;
    protected int recipient;
    protected final AtomicBoolean eof = new AtomicBoolean(false);
    protected AtomicReference<GracefulState> gracefulState = new AtomicReference<GracefulState>(GracefulState.Opened);
    protected final DefaultCloseFuture gracefulFuture = new DefaultCloseFuture(this.lock);
    protected final List<RequestHandler<Channel>> handlers = new ArrayList<RequestHandler<Channel>>();

    protected AbstractChannel() {
    }

    protected AbstractChannel(String discriminator) {
        super(discriminator);
    }

    public void addRequestHandler(RequestHandler<Channel> handler) {
        this.handlers.add(handler);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRecipient() {
        return this.recipient;
    }

    @Override
    public Window getLocalWindow() {
        return this.localWindow;
    }

    @Override
    public Window getRemoteWindow() {
        return this.remoteWindow;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.executor = service;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    public void setShutdownOnExit(boolean shutdown) {
        this.shutdownExecutor = shutdown;
    }

    @Override
    public void handleRequest(Buffer buffer) throws IOException {
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_MSG_CHANNEL_REQUEST {} on channel {} (wantReply {})", new Object[]{req, this, wantReply});
        }
        for (RequestHandler<Channel> handler : this.handlers) {
            RequestHandler.Result result;
            try {
                result = handler.process(this, req, wantReply, buffer);
            }
            catch (Exception e) {
                this.log.warn("Error processing channel request " + req, (Throwable)e);
                result = RequestHandler.Result.ReplyFailure;
            }
            if (RequestHandler.Result.Unsupported.equals((Object)result)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("{}#process({}): {}", new Object[]{handler.getClass().getSimpleName(), req, result});
                continue;
            }
            this.sendResponse(buffer, req, result, wantReply);
            return;
        }
        this.log.warn("Unknown channel request: {}", (Object)req);
        this.sendResponse(buffer, req, RequestHandler.Result.Unsupported, wantReply);
    }

    protected void sendResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) result={}, want-reply={}", new Object[]{req, result, wantReply});
        }
        if (RequestHandler.Result.Replied.equals((Object)result) || !wantReply) {
            return;
        }
        byte cmd = RequestHandler.Result.ReplySuccess.equals((Object)result) ? (byte)99 : 100;
        buffer.clear();
        buffer.ensureCapacity(10, RESPONSE_BUFFER_GROWTH_FACTOR);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        buffer.putInt(this.recipient);
        this.session.writePacket(buffer);
    }

    @Override
    public void init(ConnectionService service, Session session, int id) {
        this.service = service;
        this.session = session;
        this.id = id;
        this.configureWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public void handleClose() throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_CLOSE on channel {}", (Object)this);
        if (this.gracefulState.compareAndSet(GracefulState.Opened, GracefulState.CloseReceived)) {
            this.close(false);
        } else if (this.gracefulState.compareAndSet(GracefulState.CloseSent, GracefulState.Closed)) {
            this.gracefulFuture.setClosed();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return new GracefulChannelCloseable();
    }

    @Override
    protected void doCloseImmediately() {
        if (this.service != null) {
            this.service.unregisterChannel(this);
        }
        super.doCloseImmediately();
    }

    protected void writePacket(Buffer buffer) throws IOException {
        if (!this.isClosing()) {
            this.session.writePacket(buffer);
        } else {
            this.log.debug("Discarding output packet because channel is being closed");
        }
    }

    @Override
    public void handleData(Buffer buffer) throws IOException {
        int len = buffer.getInt();
        if (len < 0 || len > 65536) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.log.debug("Received SSH_MSG_CHANNEL_DATA on channel {}", (Object)this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received channel data: {}", (Object)BufferUtils.printHex(buffer.array(), buffer.rpos(), len));
        }
        this.doWriteData(buffer.array(), buffer.rpos(), len);
    }

    @Override
    public void handleExtendedData(Buffer buffer) throws IOException {
        int ex = buffer.getInt();
        if (ex != 1) {
            this.log.debug("Send SSH_MSG_CHANNEL_FAILURE on channel {}", (Object)this);
            buffer = this.session.createBuffer((byte)100);
            buffer.putInt(this.recipient);
            this.writePacket(buffer);
            return;
        }
        int len = buffer.getInt();
        if (len < 0 || len > 65536) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.log.debug("Received SSH_MSG_CHANNEL_EXTENDED_DATA on channel {}", (Object)this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received channel extended data: {}", (Object)BufferUtils.printHex(buffer.array(), buffer.rpos(), len));
        }
        this.doWriteExtendedData(buffer.array(), buffer.rpos(), len);
    }

    public boolean isEofSignalled() {
        return this.eof.get();
    }

    public void setEofSignalled(boolean on) {
        this.eof.set(on);
    }

    @Override
    public void handleEof() throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_EOF on channel {}", (Object)this);
        this.setEofSignalled(true);
        this.notifyStateChanged();
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_WINDOW_ADJUST on channel {}", (Object)this);
        int window = buffer.getInt();
        this.remoteWindow.expand(window);
    }

    @Override
    public void handleFailure() throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_FAILURE on channel {}", (Object)this);
    }

    protected abstract void doWriteData(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void doWriteExtendedData(byte[] var1, int var2, int var3) throws IOException;

    protected void sendEof() throws IOException {
        this.log.debug("Send SSH_MSG_CHANNEL_EOF on channel {}", (Object)this);
        Buffer buffer = this.session.createBuffer((byte)96);
        buffer.putInt(this.recipient);
        this.writePacket(buffer);
    }

    protected void configureWindow() {
        this.localWindow.init(this.session);
    }

    protected void sendWindowAdjust(int len) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Send SSH_MSG_CHANNEL_WINDOW_ADJUST on channel {}", (Object)this.id);
        }
        Buffer buffer = this.session.createBuffer((byte)93);
        buffer.putInt(this.recipient);
        buffer.putInt(len);
        this.writePacket(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", recipient=" + this.recipient + "]";
    }

    public class GracefulChannelCloseable
    extends CloseableUtils.IoBaseCloseable {
        private final AtomicBoolean closing = new AtomicBoolean(false);

        @Override
        public boolean isClosing() {
            return this.closing.get();
        }

        public void setClosing(boolean on) {
            this.closing.set(on);
        }

        @Override
        public boolean isClosed() {
            return AbstractChannel.this.gracefulFuture.isClosed();
        }

        @Override
        public CloseFuture close(boolean immediately) {
            this.setClosing(true);
            if (immediately) {
                AbstractChannel.this.gracefulFuture.setClosed();
            } else if (!AbstractChannel.this.gracefulFuture.isClosed()) {
                this.log.debug("Send SSH_MSG_CHANNEL_CLOSE on channel {}", (Object)AbstractChannel.this);
                Buffer buffer = AbstractChannel.this.session.createBuffer((byte)97);
                buffer.putInt(AbstractChannel.this.recipient);
                try {
                    long timeout = FactoryManagerUtils.getLongProperty(AbstractChannel.this.getSession(), "channel-close-timeout", 5000L);
                    AbstractChannel.this.session.writePacket(buffer, timeout, TimeUnit.MILLISECONDS).addListener(new SshFutureListener<IoWriteFuture>(){

                        @Override
                        public void operationComplete(IoWriteFuture future) {
                            if (future.isWritten()) {
                                GracefulChannelCloseable.this.log.debug("Message SSH_MSG_CHANNEL_CLOSE written on channel {}", (Object)AbstractChannel.this);
                                if (!AbstractChannel.this.gracefulState.compareAndSet(GracefulState.Opened, GracefulState.CloseSent) && AbstractChannel.this.gracefulState.compareAndSet(GracefulState.CloseReceived, GracefulState.Closed)) {
                                    AbstractChannel.this.gracefulFuture.setClosed();
                                }
                            } else {
                                GracefulChannelCloseable.this.log.debug("Failed to write SSH_MSG_CHANNEL_CLOSE on channel {}", (Object)AbstractChannel.this);
                                AbstractChannel.this.close(true);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    this.log.debug("Exception caught while writing SSH_MSG_CHANNEL_CLOSE packet on channel " + AbstractChannel.this, (Throwable)e);
                    AbstractChannel.this.close(true);
                }
            }
            ExecutorService service = AbstractChannel.this.getExecutorService();
            if (service != null && AbstractChannel.this.isShutdownOnExit() && !service.isShutdown()) {
                List<Runnable> running = service.shutdownNow();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Shutdown executor service on close - running count=" + GenericUtils.size(running));
                }
            }
            return AbstractChannel.this.gracefulFuture;
        }
    }

    protected static enum GracefulState {
        Opened,
        CloseSent,
        CloseReceived,
        Closed;

    }
}

