/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class BufferedIoOutputStream
extends CloseableUtils.AbstractInnerCloseable
implements IoOutputStream {
    private final IoOutputStream out;
    private final Queue<IoWriteFutureImpl> writes = new ConcurrentLinkedQueue<IoWriteFutureImpl>();
    private final AtomicReference<IoWriteFutureImpl> currentWrite = new AtomicReference();

    public BufferedIoOutputStream(IoOutputStream out) {
        this.out = out;
    }

    @Override
    public IoWriteFuture write(Buffer buffer) {
        IoWriteFutureImpl future = new IoWriteFutureImpl(buffer);
        if (this.isClosing()) {
            future.setValue(new IOException("Closed"));
        } else {
            this.writes.add(future);
            this.startWriting();
        }
        return future;
    }

    private void startWriting() {
        final IoWriteFutureImpl future = this.writes.peek();
        if (future != null && this.currentWrite.compareAndSet(null, future)) {
            this.out.write(future.getBuffer()).addListener(new SshFutureListener<IoWriteFuture>(){

                @Override
                public void operationComplete(IoWriteFuture f) {
                    if (f.isWritten()) {
                        future.setValue(Boolean.TRUE);
                    } else {
                        future.setValue(f.getException());
                    }
                    this.finishWrite();
                }

                private void finishWrite() {
                    BufferedIoOutputStream.this.writes.remove(future);
                    BufferedIoOutputStream.this.currentWrite.compareAndSet(future, null);
                    BufferedIoOutputStream.this.startWriting();
                }
            });
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().when(this.writes).close(this.out).build();
    }

    public String toString() {
        return "BufferedIoOutputStream[" + this.out + "]";
    }
}

