/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BaseCipher;
import org.apache.sshd.common.cipher.BaseRC4Cipher;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.config.NamedFactoriesListParseResult;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public enum BuiltinCiphers implements CipherFactory
{
    none("none", 0, 0, "None", "None"){

        @Override
        public Cipher create() {
            return new CipherNone();
        }
    }
    ,
    aes128cbc("aes128-cbc", 16, 16, "AES", "AES/CBC/NoPadding"),
    aes128ctr("aes128-ctr", 16, 16, "AES", "AES/CTR/NoPadding"),
    aes192cbc("aes192-cbc", 16, 24, "AES", "AES/CBC/NoPadding"),
    aes192ctr("aes192-ctr", 16, 24, "AES", "AES/CTR/NoPadding"),
    aes256cbc("aes256-cbc", 16, 32, "AES", "AES/CBC/NoPadding"),
    aes256ctr("aes256-ctr", 16, 32, "AES", "AES/CTR/NoPadding"),
    arcfour128("arcfour128", 8, 16, "ARCFOUR", "RC4"){

        @Override
        public Cipher create() {
            return new BaseRC4Cipher(this.getIVSize(), this.getBlockSize());
        }
    }
    ,
    arcfour256("arcfour256", 8, 32, "ARCFOUR", "RC4"){

        @Override
        public Cipher create() {
            return new BaseRC4Cipher(this.getIVSize(), this.getBlockSize());
        }
    }
    ,
    blowfishcbc("blowfish-cbc", 8, 16, "Blowfish", "Blowfish/CBC/NoPadding"),
    tripledescbc("3des-cbc", 8, 24, "DESede", "DESede/CBC/NoPadding");

    public static final Set<BuiltinCiphers> VALUES;
    private static final Map<String, CipherFactory> EXTENSIONS;
    private final String factoryName;
    private final int ivsize;
    private final int blocksize;
    private final int keysize;
    private final String algorithm;
    private final String transformation;
    private final boolean supported;

    private BuiltinCiphers(String factoryName, int ivsize, int blocksize, String algorithm, String transformation) {
        this.factoryName = factoryName;
        this.ivsize = ivsize;
        this.blocksize = blocksize;
        this.keysize = blocksize * 8;
        this.algorithm = algorithm;
        this.transformation = transformation;
        this.supported = BuiltinCiphers.checkSupported(this.transformation, this.keysize);
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    private static boolean checkSupported(String xform, int keyLength) {
        try {
            int maxKeyLength = javax.crypto.Cipher.getMaxAllowedKeyLength(xform);
            return maxKeyLength >= keyLength;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getKeySize() {
        return this.keysize;
    }

    public int getIVSize() {
        return this.ivsize;
    }

    public int getBlockSize() {
        return this.blocksize;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public Cipher create() {
        return new BaseCipher(this.getIVSize(), this.getBlockSize(), this.getAlgorithm(), this.getTransformation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(CipherFactory extension) {
        String name = ValidateUtils.checkNotNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinCiphers.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<CipherFactory> getRegisteredExtensions() {
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedFactory<Cipher> unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinCiphers fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (BuiltinCiphers c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static BuiltinCiphers fromFactory(NamedFactory<Cipher> factory) {
        if (factory == null) {
            return null;
        }
        return BuiltinCiphers.fromFactoryName(factory.getName());
    }

    public static BuiltinCiphers fromFactoryName(String name) {
        return NamedResource.Utils.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ParseResult parseCiphersList(String ciphers) {
        return BuiltinCiphers.parseCiphersList(GenericUtils.split(ciphers, ','));
    }

    public static ParseResult parseCiphersList(String ... ciphers) {
        return BuiltinCiphers.parseCiphersList(GenericUtils.isEmpty((Object[])ciphers) ? Collections.emptyList() : Arrays.asList(ciphers));
    }

    public static ParseResult parseCiphersList(Collection<String> ciphers) {
        if (GenericUtils.isEmpty(ciphers)) {
            return ParseResult.EMPTY;
        }
        ArrayList<CipherFactory> factories = new ArrayList<CipherFactory>(ciphers.size());
        List<String> unknown = Collections.emptyList();
        for (String name : ciphers) {
            CipherFactory c = BuiltinCiphers.resolveFactory(name);
            if (c != null) {
                factories.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<CipherFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinCiphers c = BuiltinCiphers.fromFactoryName(name);
        if (c != null) {
            return c;
        }
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinCiphers.class));
        EXTENSIONS = new TreeMap<String, CipherFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static class Constants {
        public static final String NONE = "none";
        public static final Pattern NONE_CIPHER_PATTERN = Pattern.compile("(^|.*,)none($|,.*)");
        public static final String AES128_CBC = "aes128-cbc";
        public static final String AES128_CTR = "aes128-ctr";
        public static final String AES192_CBC = "aes192-cbc";
        public static final String AES192_CTR = "aes192-ctr";
        public static final String AES256_CBC = "aes256-cbc";
        public static final String AES256_CTR = "aes256-ctr";
        public static final String ARCFOUR128 = "arcfour128";
        public static final String ARCFOUR256 = "arcfour256";
        public static final String BLOWFISH_CBC = "blowfish-cbc";
        public static final String TRIPLE_DES_CBC = "3des-cbc";

        public static boolean isNoneCipherIncluded(String s) {
            if (GenericUtils.isEmpty(s)) {
                return false;
            }
            Matcher m = NONE_CIPHER_PATTERN.matcher(s);
            return m.matches();
        }
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<Cipher, CipherFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<CipherFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

