/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.util.buffer.Buffer;

public class CompressionZlib
implements Compression {
    private static final int BUF_SIZE = 4096;
    private byte[] tmpbuf = new byte[4096];
    private Deflater compresser;
    private Inflater decompresser;

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void init(Compression.Type type, int level) {
        this.compresser = new Deflater(level);
        this.decompresser = new Inflater();
    }

    @Override
    public void compress(Buffer buffer) throws IOException {
        int len;
        this.compresser.setInput(buffer.array(), buffer.rpos(), buffer.available());
        buffer.wpos(buffer.rpos());
        while ((len = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2)) > 0) {
            buffer.putRawBytes(this.tmpbuf, 0, len);
        }
    }

    @Override
    public void uncompress(Buffer from, Buffer to) throws IOException {
        this.decompresser.setInput(from.array(), from.rpos(), from.available());
        try {
            int len;
            while ((len = this.decompresser.inflate(this.tmpbuf)) > 0) {
                to.putRawBytes(this.tmpbuf, 0, len);
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Error decompressing data", e);
        }
    }
}

