/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.security.MessageDigest;
import java.util.Objects;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class BaseDigest
implements Digest {
    private final String algorithm;
    private final int bsize;
    private final int h;
    private final String s;
    private MessageDigest md;

    public BaseDigest(String algorithm, int bsize) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        ValidateUtils.checkTrue(bsize > 0, "Invalid block size: %d", (Object)bsize);
        this.bsize = bsize;
        this.s = this.getClass().getSimpleName() + "[" + algorithm + ":" + bsize + "]";
        this.h = Objects.hashCode(algorithm) + bsize;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init() throws Exception {
        this.md = SecurityUtils.getMessageDigest(this.getAlgorithm());
    }

    @Override
    public void update(byte[] data) throws Exception {
        this.update(data, 0, GenericUtils.length(data));
    }

    @Override
    public void update(byte[] data, int start, int len) throws Exception {
        this.md.update(data, start, len);
    }

    @Override
    public byte[] digest() throws Exception {
        return this.md.digest();
    }

    public int hashCode() {
        return this.h;
    }

    @Override
    public int compareTo(Digest that) {
        String thatAlg;
        if (that == null) {
            return -1;
        }
        if (this == that) {
            return 0;
        }
        String thisAlg = this.getAlgorithm();
        int nRes = GenericUtils.safeCompare(thisAlg, thatAlg = that.getAlgorithm(), false);
        if (nRes != 0) {
            return nRes;
        }
        nRes = Integer.compare(this.getBlockSize(), that.getBlockSize());
        if (nRes != 0) {
            return nRes;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        int nRes = this.compareTo((Digest)obj);
        return nRes == 0;
    }

    public String toString() {
        return this.s;
    }
}

