/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class NativeFileSystemFactory
extends AbstractLoggingBean
implements FileSystemFactory {
    public static final NativeFileSystemFactory INSTANCE = new NativeFileSystemFactory();
    private boolean createHome;

    public NativeFileSystemFactory() {
        this(false);
    }

    public NativeFileSystemFactory(boolean createHome) {
        this.createHome = createHome;
    }

    public boolean isCreateHome() {
        return this.createHome;
    }

    public void setCreateHome(boolean createHome) {
        this.createHome = createHome;
    }

    @Override
    public FileSystem createFileSystem(Session session) {
        String userName = session.getUsername();
        if (this.createHome) {
            String homeDirStr = "/home/" + userName;
            File homeDir = new File(homeDirStr);
            if (homeDir.isFile()) {
                this.log.warn("Not a directory :: " + homeDirStr);
            }
            if (!homeDir.exists() && !homeDir.mkdirs()) {
                this.log.warn("Cannot create user home :: " + homeDirStr);
            }
        }
        return FileSystems.getDefault();
    }
}

