/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class LocalForwardingEntry
extends SshdSocketAddress {
    private static final long serialVersionUID = 423661570180889621L;
    private final String alias;

    public LocalForwardingEntry(String hostName, String alias, int port) {
        super(hostName, port);
        this.alias = ValidateUtils.checkNotNullAndNotEmpty(alias, "No host alias");
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    protected boolean isEquivalent(SshdSocketAddress that) {
        if (super.isEquivalent(that) && that instanceof LocalForwardingEntry) {
            LocalForwardingEntry entry = (LocalForwardingEntry)that;
            if (Objects.equals(this.getAlias(), entry.getAlias())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.getAlias());
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.getAlias();
    }

    public static final LocalForwardingEntry findMatchingEntry(String host, int port, Collection<? extends LocalForwardingEntry> entries) {
        if (GenericUtils.isEmpty(host) || port <= 0 || GenericUtils.isEmpty(entries)) {
            return null;
        }
        for (LocalForwardingEntry localForwardingEntry : entries) {
            if (port != localForwardingEntry.getPort() || !host.equals(localForwardingEntry.getHostName()) && !host.equals(localForwardingEntry.getAlias())) continue;
            return localForwardingEntry;
        }
        return null;
    }
}

