/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.mina.MinaService;
import org.apache.sshd.common.io.mina.MinaSupport;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class MinaSession
extends CloseableUtils.AbstractInnerCloseable
implements IoSession {
    private final MinaService service;
    private final org.apache.mina.core.session.IoSession session;

    public MinaSession(MinaService service, org.apache.mina.core.session.IoSession session) {
        this.service = service;
        this.session = session;
    }

    public org.apache.mina.core.session.IoSession getSession() {
        return this.session;
    }

    public void suspend() {
        this.session.suspendRead();
        this.session.suspendWrite();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public long getId() {
        return this.session.getId();
    }

    public WriteFuture write(byte[] data, int offset, int len) {
        IoBuffer buffer = IoBuffer.wrap((byte[])data, (int)offset, (int)len);
        return this.session.write((Object)buffer);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return new CloseableUtils.IoBaseCloseable(){

            @Override
            public boolean isClosing() {
                return MinaSession.this.session.isClosing();
            }

            @Override
            public boolean isClosed() {
                return !MinaSession.this.session.isConnected();
            }

            @Override
            public CloseFuture close(boolean immediately) {
                final DefaultCloseFuture future = new DefaultCloseFuture(MinaSession.this.lock);
                MinaSession.this.session.close(false).addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                    public void operationComplete(IoFuture f) {
                        future.setValue(Boolean.TRUE);
                    }
                });
                return future;
            }
        };
    }

    @Override
    public IoWriteFuture write(Buffer buffer) {
        final Future future = new Future((Object)null);
        this.session.write((Object)MinaSupport.asIoBuffer(buffer)).addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

            public void operationComplete(WriteFuture cf) {
                if (cf.getException() != null) {
                    future.setException(cf.getException());
                } else {
                    future.setWritten();
                }
            }
        });
        return future;
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.session.getLocalAddress() + ", remote=" + this.session.getRemoteAddress() + "]";
    }

    private static class Future
    extends AbstractIoWriteFuture {
        Future(Object lock) {
            super(lock);
        }

        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        public void setException(Throwable exception) {
            this.setValue(ValidateUtils.checkNotNull(exception, "No exception specified"));
        }
    }
}

