/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2DefaultIoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;

public class Nio2Session
extends CloseableUtils.AbstractCloseable
implements IoSession {
    public static final int DEFAULT_READBUF_SIZE = 32768;
    private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(100L);
    private final long id = SESSION_ID_GENERATOR.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler handler;
    private final AsynchronousSocketChannel socket;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final FactoryManager manager;
    private final Queue<Nio2DefaultIoWriteFuture> writes = new LinkedTransferQueue<Nio2DefaultIoWriteFuture>();
    private final AtomicReference<Nio2DefaultIoWriteFuture> currentWrite = new AtomicReference();

    public Nio2Session(Nio2Service service, FactoryManager manager, IoHandler handler, AsynchronousSocketChannel socket) throws IOException {
        this.service = service;
        this.manager = manager;
        this.handler = handler;
        this.socket = socket;
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        this.log.debug("Creating IoSession on {} from {}", (Object)this.localAddress, (Object)this.remoteAddress);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void suspend() {
        try {
            this.socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public IoWriteFuture write(Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Writing {} bytes", (Object)buffer.available());
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        Nio2DefaultIoWriteFuture future = new Nio2DefaultIoWriteFuture(null, buf);
        if (this.isClosing()) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    private void exceptionCaught(Throwable exc) {
        if (!this.closeFuture.isClosed()) {
            if (this.isClosing() || !this.socket.isOpen()) {
                this.close(true);
            } else {
                try {
                    this.log.debug("Caught exception, now calling handler");
                    this.handler.exceptionCaught(this, exc);
                }
                catch (Throwable t) {
                    this.log.info("Exception handler threw exception, closing the session", t);
                    this.close(true);
                }
            }
        }
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        return this.builder().when(this.writes).build().close(false);
    }

    @Override
    protected void doCloseImmediately() {
        Nio2DefaultIoWriteFuture future;
        while ((future = this.writes.poll()) != null) {
            future.setException(new ClosedChannelException());
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.log.info("Exception caught while closing socket", (Throwable)e);
        }
        this.service.sessionClosed(this);
        super.doCloseImmediately();
        try {
            this.handler.sessionClosed(this);
        }
        catch (Exception e) {
            this.log.debug("Exception caught while calling IoHandler#sessionClosed", (Throwable)e);
        }
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    public void startReading() {
        this.startReading(FactoryManagerUtils.getIntProperty(this.manager, "nio2-read-buf-size", 32768));
    }

    public void startReading(int bufSize) {
        this.startReading(new byte[bufSize]);
    }

    public void startReading(byte[] buf) {
        this.startReading(buf, 0, buf.length);
    }

    public void startReading(byte[] buf, int offset, int len) {
        this.startReading(ByteBuffer.wrap(buf, offset, len));
    }

    public void startReading(final ByteBuffer buffer) {
        this.doReadCycle(buffer, new Readable(){

            @Override
            public int available() {
                return buffer.remaining();
            }

            @Override
            public void getRawBytes(byte[] data, int offset, int len) {
                buffer.get(data, offset, len);
            }
        });
    }

    protected void doReadCycle(final ByteBuffer buffer, final Readable bufReader) {
        Nio2CompletionHandler<Integer, Object> completion = new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                try {
                    if (result >= 0) {
                        Nio2Session.this.log.debug("Read {} bytes", (Object)result);
                        buffer.flip();
                        Nio2Session.this.handler.messageReceived(Nio2Session.this, bufReader);
                        if (!Nio2Session.this.closeFuture.isClosed()) {
                            buffer.clear();
                            Nio2Session.this.doReadCycle(buffer, this);
                        } else {
                            Nio2Session.this.log.debug("IoSession has been closed, stop reading");
                        }
                    } else {
                        Nio2Session.this.log.debug("Socket has been disconnected, closing IoSession now");
                        Nio2Session.this.close(true);
                    }
                }
                catch (Throwable exc) {
                    this.failed(exc, attachment);
                }
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.exceptionCaught(exc);
            }
        };
        this.doReadCycle(buffer, completion);
    }

    protected void doReadCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        this.socket.read(buffer, null, completion);
    }

    private void startWriting() {
        final Nio2DefaultIoWriteFuture future = this.writes.peek();
        if (future != null && this.currentWrite.compareAndSet(null, future)) {
            try {
                final ByteBuffer buffer = future.getBuffer();
                this.socket.write(buffer, null, new Nio2CompletionHandler<Integer, Object>(){

                    @Override
                    protected void onCompleted(Integer result, Object attachment) {
                        if (buffer.hasRemaining()) {
                            try {
                                Nio2Session.this.socket.write(buffer, null, this);
                            }
                            catch (Throwable t) {
                                Nio2Session.this.log.debug("Exception caught while writing", t);
                                future.setWritten();
                                this.finishWrite();
                            }
                        } else {
                            Nio2Session.this.log.debug("Finished writing");
                            future.setWritten();
                            this.finishWrite();
                        }
                    }

                    @Override
                    protected void onFailed(Throwable exc, Object attachment) {
                        future.setException(exc);
                        Nio2Session.this.exceptionCaught(exc);
                        this.finishWrite();
                    }

                    private void finishWrite() {
                        Nio2Session.this.writes.remove(future);
                        Nio2Session.this.currentWrite.compareAndSet(future, null);
                        Nio2Session.this.startWriting();
                    }
                });
            }
            catch (RuntimeException e) {
                future.setWritten();
                throw e;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.localAddress + ", remote=" + this.remoteAddress + "]";
    }
}

