/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;

public abstract class AbstractFileKeyPairProvider
extends AbstractResourceKeyPairProvider<Path> {
    private Collection<? extends Path> files;

    protected AbstractFileKeyPairProvider() {
    }

    public Collection<? extends Path> getPaths() {
        return this.files;
    }

    public void setFiles(Collection<File> files) {
        if (GenericUtils.isEmpty(files)) {
            this.setPaths(Collections.emptyList());
        } else {
            ArrayList<Path> paths = new ArrayList<Path>(files.size());
            for (File f : files) {
                paths.add(f.toPath());
            }
            this.setPaths(paths);
        }
    }

    public void setPaths(Collection<? extends Path> paths) {
        ArrayList<? extends Path> resolved;
        int numPaths = GenericUtils.size(paths);
        ArrayList<? extends Path> arrayList = resolved = numPaths <= 0 ? Collections.emptyList() : new ArrayList<Path>(paths.size());
        if (numPaths > 0) {
            for (Path path : paths) {
                resolved.add(path.toAbsolutePath());
            }
        }
        this.resetCacheMap(resolved);
        this.files = resolved;
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        return this.loadKeys(this.getPaths());
    }

    @Override
    protected KeyPair doLoadKey(Path resource) throws IOException, GeneralSecurityException {
        return super.doLoadKey(resource == null ? null : resource.toAbsolutePath());
    }

    @Override
    protected InputStream openKeyPairResource(String resourceKey, Path resource) throws IOException {
        return Files.newInputStream(resource, IoUtils.EMPTY_OPEN_OPTIONS);
    }
}

