/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SessionTimeoutListener
extends AbstractLoggingBean
implements SessionListener,
Runnable {
    private final Set<AbstractSession> sessions = new CopyOnWriteArraySet<AbstractSession>();

    @Override
    public void sessionCreated(Session session) {
        if (session instanceof AbstractSession && (session.getAuthTimeout() > 0L || session.getIdleTimeout() > 0L)) {
            this.sessions.add((AbstractSession)session);
        }
    }

    @Override
    public void sessionEvent(Session session, SessionListener.Event event) {
    }

    @Override
    public void sessionClosed(Session s) {
        this.sessions.remove(s);
    }

    @Override
    public void run() {
        for (AbstractSession session : this.sessions) {
            try {
                session.checkForTimeouts();
            }
            catch (Exception e) {
                this.log.warn("An error occurred while checking session=" + session + " timeouts", (Throwable)e);
            }
        }
    }
}

