/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp.extensions;

import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.subsystem.sftp.extensions.AbstractParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class NewlineParser
extends AbstractParser<Newline> {
    public static final NewlineParser INSTANCE = new NewlineParser();

    public NewlineParser() {
        super("newline");
    }

    @Override
    public Newline parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public Newline parse(String value) {
        Newline nl = new Newline();
        nl.newline = value;
        return nl;
    }

    public static class Newline {
        public String newline;

        public String toString() {
            if (GenericUtils.isEmpty(this.newline)) {
                return this.newline;
            }
            return BufferUtils.printHex(':', this.newline.getBytes(StandardCharsets.UTF_8));
        }
    }
}

