/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.util.SelectorUtils;

public class DirectoryScanner {
    protected File basedir;
    protected String[] includes;
    protected List<String> filesIncluded;
    protected boolean isCaseSensitive = true;

    public DirectoryScanner() {
    }

    public DirectoryScanner(String basedir, String ... includes) {
        this.setBasedir(basedir);
        this.setIncludes(includes);
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                this.includes[i] = this.normalizePattern(includes[i]);
            }
        }
    }

    public String[] scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null || this.includes.length == 0) {
            throw new IllegalStateException("No includes set ");
        }
        this.filesIncluded = new ArrayList<String>();
        this.scandir(this.basedir, "");
        return this.getIncludedFiles();
    }

    protected void scandir(File dir, String vpath) {
        String[] newfiles = dir.list();
        if (newfiles == null) {
            newfiles = new String[]{};
        }
        for (String newfile : newfiles) {
            String name = vpath + newfile;
            File file = new File(dir, newfile);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    this.filesIncluded.add(name);
                    this.scandir(file, name + File.separator);
                    continue;
                }
                if (!this.couldHoldIncluded(name)) continue;
                this.scandir(file, name + File.separator);
                continue;
            }
            if (!file.isFile() || !this.isIncluded(name)) continue;
            this.filesIncluded.add(name);
        }
    }

    public String[] getIncludedFiles() {
        String[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.toArray(files);
        return files;
    }

    protected boolean isIncluded(String name) {
        for (String include : this.includes) {
            if (!SelectorUtils.matchPath(include, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        for (String include : this.includes) {
            if (!SelectorUtils.matchPatternStart(include, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    private String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? DirectoryScanner.replace(pattern, "/", "\\\\", -1) : DirectoryScanner.replace(pattern, "\\\\", "/", -1);
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public static String replace(String text, String repl, String with, int max) {
        int end;
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

