/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;

public final class EventListenerUtils {
    private EventListenerUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <T extends EventListener> T proxyWrapper(Class<T> listenerType, Iterable<? extends T> listeners) {
        return EventListenerUtils.proxyWrapper(listenerType, listenerType.getClassLoader(), listeners);
    }

    public static <T extends EventListener> T proxyWrapper(Class<T> listenerType, ClassLoader loader, final Iterable<? extends T> listeners) {
        if (listenerType == null || !listenerType.isInterface()) {
            throw new IllegalArgumentException("Target proxy is not an interface");
        }
        if (listeners == null) {
            throw new IllegalArgumentException("No listeners container provided");
        }
        Object wrapper = Proxy.newProxyInstance(loader, new Class[]{listenerType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                for (EventListener l : listeners) {
                    method.invoke((Object)l, args);
                }
                return null;
            }
        });
        return (T)((EventListener)listenerType.cast(wrapper));
    }
}

