/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.Transformer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;

public abstract class Buffer
implements Readable {
    protected final byte[] workBuf = new byte[8];

    protected Buffer() {
    }

    public abstract int rpos();

    public abstract void rpos(int var1);

    public abstract int wpos();

    public abstract void wpos(int var1);

    public abstract int capacity();

    public abstract byte[] array();

    public abstract void compact();

    public byte[] getCompactData() {
        int l = this.available();
        if (l > 0) {
            byte[] b = new byte[l];
            System.arraycopy(this.array(), this.rpos(), b, 0, l);
            return b;
        }
        return GenericUtils.EMPTY_BYTE_ARRAY;
    }

    public abstract void clear();

    public String printHex() {
        return BufferUtils.printHex(this.array(), this.rpos(), this.available());
    }

    public int getUByte() {
        return this.getByte() & 0xFF;
    }

    public byte getByte() {
        this.ensureAvailable(1);
        this.getRawBytes(this.workBuf, 0, 1);
        return this.workBuf[0];
    }

    public short getShort() {
        this.ensureAvailable(2);
        this.getRawBytes(this.workBuf, 0, 2);
        short v = (short)(this.workBuf[1] << 8 & 0xFF00);
        v = (short)(v | this.workBuf[0] & 0xF);
        return v;
    }

    public int getInt() {
        return (int)this.getUInt();
    }

    public long getUInt() {
        this.ensureAvailable(4);
        this.getRawBytes(this.workBuf, 0, 4);
        return BufferUtils.getUInt(this.workBuf, 0, 4);
    }

    public long getLong() {
        this.ensureAvailable(8);
        this.getRawBytes(this.workBuf, 0, 8);
        long l = (long)this.workBuf[0] << 56 & 0xFF00000000000000L;
        l |= (long)this.workBuf[1] << 48 & 0xFF000000000000L;
        l |= (long)this.workBuf[2] << 40 & 0xFF0000000000L;
        l |= (long)this.workBuf[3] << 32 & 0xFF00000000L;
        l |= (long)this.workBuf[4] << 24 & 0xFF000000L;
        l |= (long)this.workBuf[5] << 16 & 0xFF0000L;
        l |= (long)this.workBuf[6] << 8 & 0xFF00L;
        return l |= (long)this.workBuf[7] & 0xFFL;
    }

    public boolean getBoolean() {
        return this.getByte() != 0;
    }

    public String getString() {
        return this.getString(StandardCharsets.UTF_8);
    }

    public Collection<String> getStringList(boolean usePrependedLength) {
        return this.getStringList(usePrependedLength, StandardCharsets.UTF_8);
    }

    public Collection<String> getStringList(boolean usePrependedLength, Charset charset) {
        if (usePrependedLength) {
            int count = this.getInt();
            return this.getStringList(count, charset);
        }
        return this.getAvailableStrings(charset);
    }

    public Collection<String> getAvailableStrings() {
        return this.getAvailableStrings(StandardCharsets.UTF_8);
    }

    public Collection<String> getAvailableStrings(Charset charset) {
        LinkedList<String> list = new LinkedList<String>();
        while (this.available() > 0) {
            String s = this.getString(charset);
            list.add(s);
        }
        return list;
    }

    public List<String> getStringList(int count) {
        return this.getStringList(count, StandardCharsets.UTF_8);
    }

    public List<String> getStringList(int count, Charset charset) {
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            String s = this.getString(charset);
            list.add(s);
        }
        return list;
    }

    public abstract String getString(Charset var1);

    public BigInteger getMPInt() {
        return new BigInteger(this.getMPIntAsBytes());
    }

    public byte[] getMPIntAsBytes() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        int len = this.getInt();
        if (len < 0) {
            throw new BufferException("Bad item length: " + len);
        }
        this.ensureAvailable(len);
        byte[] b = new byte[len];
        this.getRawBytes(b);
        return b;
    }

    public void getRawBytes(byte[] buf) {
        this.getRawBytes(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey() throws SshException {
        int ow = this.wpos();
        int len = this.getInt();
        this.wpos(this.rpos() + len);
        try {
            PublicKey publicKey = this.getRawPublicKey();
            return publicKey;
        }
        finally {
            this.wpos(ow);
        }
    }

    public PublicKey getRawPublicKey() throws SshException {
        try {
            String keyAlg = this.getString();
            if ("ssh-rsa".equals(keyAlg)) {
                BigInteger e = this.getMPInt();
                BigInteger n = this.getMPInt();
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                return keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
            }
            if ("ssh-dss".equals(keyAlg)) {
                BigInteger p = this.getMPInt();
                BigInteger q = this.getMPInt();
                BigInteger g = this.getMPInt();
                BigInteger y = this.getMPInt();
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
                return keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
            }
            ECCurves curve = ECCurves.fromKeyType(keyAlg);
            if (curve == null) {
                throw new NoSuchAlgorithmException("Unsupported raw public algorithm: " + keyAlg);
            }
            String curveName = curve.getName();
            ECParameterSpec params = curve.getParameters();
            return this.getRawECKey(curveName, params);
        }
        catch (GeneralSecurityException e) {
            throw new SshException(e);
        }
    }

    protected PublicKey getRawECKey(String expectedCurve, ECParameterSpec spec) throws GeneralSecurityException {
        ECPoint w;
        String curveName = this.getString();
        if (!expectedCurve.equals(curveName)) {
            throw new InvalidKeySpecException("getRawECKey(" + expectedCurve + ") curve name does not match expected: " + curveName);
        }
        if (spec == null) {
            throw new InvalidKeySpecException("getRawECKey(" + expectedCurve + ") missing curve parameters");
        }
        byte[] octets = this.getBytes();
        try {
            w = ECDSAPublicKeyEntryDecoder.octetStringToEcPoint(octets);
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("getRawECKey(" + expectedCurve + ")" + " cannot (" + e.getClass().getSimpleName() + ")" + " retrieve W value: " + e.getMessage(), e);
        }
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        return keyFactory.generatePublic(new ECPublicKeySpec(w, spec));
    }

    public KeyPair getKeyPair() throws SshException {
        try {
            PrivateKey prv;
            PublicKey pub;
            String keyAlg = this.getString();
            if ("ssh-rsa".equals(keyAlg)) {
                BigInteger e = this.getMPInt();
                BigInteger n = this.getMPInt();
                BigInteger d = this.getMPInt();
                BigInteger qInv = this.getMPInt();
                BigInteger q = this.getMPInt();
                BigInteger p = this.getMPInt();
                BigInteger dP = d.remainder(p.subtract(BigInteger.valueOf(1L)));
                BigInteger dQ = d.remainder(q.subtract(BigInteger.valueOf(1L)));
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                pub = keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
                prv = keyFactory.generatePrivate(new RSAPrivateCrtKeySpec(n, e, d, p, q, dP, dQ, qInv));
            } else if ("ssh-dss".equals(keyAlg)) {
                BigInteger p = this.getMPInt();
                BigInteger q = this.getMPInt();
                BigInteger g = this.getMPInt();
                BigInteger y = this.getMPInt();
                BigInteger x = this.getMPInt();
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
                pub = keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
                prv = keyFactory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g));
            } else {
                ECCurves curve = ECCurves.fromKeyType(keyAlg);
                if (curve == null) {
                    throw new NoSuchAlgorithmException("Unsupported key pair algorithm: " + keyAlg);
                }
                String curveName = curve.getName();
                ECParameterSpec params = curve.getParameters();
                return this.extractEC(curveName, params);
            }
            return new KeyPair(pub, prv);
        }
        catch (GeneralSecurityException e) {
            throw new SshException(e);
        }
    }

    protected KeyPair extractEC(String expectedCurveName, ECParameterSpec spec) throws GeneralSecurityException {
        ECPoint group;
        String curveName = this.getString();
        if (!expectedCurveName.equals(curveName)) {
            throw new InvalidKeySpecException("extractEC(" + expectedCurveName + ") mismatched curve name: " + curveName);
        }
        byte[] groupBytes = this.getBytes();
        BigInteger exponent = this.getMPInt();
        if (spec == null) {
            throw new InvalidKeySpecException("extractEC(" + expectedCurveName + ") missing parameters for curve");
        }
        try {
            group = ECDSAPublicKeyEntryDecoder.octetStringToEcPoint(groupBytes);
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("extractEC(" + expectedCurveName + ")" + " failed (" + e.getClass().getSimpleName() + ")" + " to decode EC group for curve: " + e.getMessage(), e);
        }
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        PublicKey pubKey = keyFactory.generatePublic(new ECPublicKeySpec(group, spec));
        PrivateKey privKey = keyFactory.generatePrivate(new ECPrivateKeySpec(exponent, spec));
        return new KeyPair(pubKey, privKey);
    }

    public void ensureAvailable(int a) throws BufferException {
        if (this.available() < a) {
            throw new BufferException("Underflow");
        }
    }

    public void putByte(byte b) {
        this.ensureCapacity(1);
        this.workBuf[0] = b;
        this.putRawBytes(this.workBuf, 0, 1);
    }

    public void putBuffer(Readable buffer) {
        this.putBuffer(buffer, true);
    }

    public abstract int putBuffer(Readable var1, boolean var2);

    public void putShort(int i) {
        this.ensureCapacity(2);
        this.workBuf[0] = (byte)(i >> 8);
        this.workBuf[1] = (byte)i;
        this.putRawBytes(this.workBuf, 0, 2);
    }

    public void putInt(long i) {
        this.ensureCapacity(4);
        BufferUtils.putUInt(i, this.workBuf, 0, 4);
        this.putRawBytes(this.workBuf, 0, 4);
    }

    public void putLong(long i) {
        this.ensureCapacity(8);
        this.workBuf[0] = (byte)(i >> 56);
        this.workBuf[1] = (byte)(i >> 48);
        this.workBuf[2] = (byte)(i >> 40);
        this.workBuf[3] = (byte)(i >> 32);
        this.workBuf[4] = (byte)(i >> 24);
        this.workBuf[5] = (byte)(i >> 16);
        this.workBuf[6] = (byte)(i >> 8);
        this.workBuf[7] = (byte)i;
        this.putRawBytes(this.workBuf, 0, 8);
    }

    public void putBoolean(boolean b) {
        this.putByte(b ? (byte)1 : 0);
    }

    public void putBytes(byte[] b) {
        this.putBytes(b, 0, b.length);
    }

    public void putBytes(byte[] b, int off, int len) {
        this.putInt(len);
        this.putRawBytes(b, off, len);
    }

    public void putStringList(Collection<?> objects, boolean prependLength) {
        this.putStringList(objects, StandardCharsets.UTF_8, prependLength);
    }

    public void putStringList(Collection<?> objects, Charset charset, boolean prependLength) {
        int numObjects = GenericUtils.size(objects);
        if (prependLength) {
            this.putInt(numObjects);
        }
        if (numObjects <= 0) {
            return;
        }
        for (Object o : objects) {
            this.putString(Transformer.TOSTRING.transform(o), charset);
        }
    }

    public void putString(String string) {
        this.putString(string, StandardCharsets.UTF_8);
    }

    public void putString(String string, Charset charset) {
        this.putBytes(GenericUtils.isEmpty(string) ? GenericUtils.EMPTY_BYTE_ARRAY : string.getBytes(charset));
    }

    public void putMPInt(BigInteger bi) {
        this.putMPInt(bi.toByteArray());
    }

    public void putMPInt(byte[] foo) {
        if ((foo[0] & 0x80) != 0) {
            this.putInt(foo.length + 1);
            this.putByte((byte)0);
        } else {
            this.putInt(foo.length);
        }
        this.putRawBytes(foo);
    }

    public void putRawBytes(byte[] d) {
        this.putRawBytes(d, 0, d.length);
    }

    public abstract void putRawBytes(byte[] var1, int var2, int var3);

    public void putPublicKey(PublicKey key) {
        int ow = this.wpos();
        this.putInt(0L);
        int ow1 = this.wpos();
        this.putRawPublicKey(key);
        int ow2 = this.wpos();
        this.wpos(ow);
        this.putInt(ow2 - ow1);
        this.wpos(ow2);
    }

    public void putRawPublicKey(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)key;
            this.putString("ssh-rsa");
            this.putMPInt(rsaPub.getPublicExponent());
            this.putMPInt(rsaPub.getModulus());
        } else if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaPub = (DSAPublicKey)key;
            DSAParams dsaParams = dsaPub.getParams();
            this.putString("ssh-dss");
            this.putMPInt(dsaParams.getP());
            this.putMPInt(dsaParams.getQ());
            this.putMPInt(dsaParams.getG());
            this.putMPInt(dsaPub.getY());
        } else if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            ECParameterSpec ecParams = ecKey.getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecParams);
            if (curve == null) {
                throw new BufferException("Unsupported EC curve parameters");
            }
            this.putString(curve.getKeyType());
            this.putString(curve.getName());
            this.putBytes(ECCurves.encodeECPoint(ecKey.getW(), ecParams));
        } else {
            throw new BufferException("Unsupported raw public key algorithm: " + key.getAlgorithm());
        }
    }

    public void putKeyPair(KeyPair kp) {
        PublicKey pubKey = kp.getPublic();
        PrivateKey prvKey = kp.getPrivate();
        if (prvKey instanceof RSAPrivateCrtKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)pubKey;
            RSAPrivateCrtKey rsaPrv = (RSAPrivateCrtKey)prvKey;
            this.putString("ssh-rsa");
            this.putMPInt(rsaPub.getPublicExponent());
            this.putMPInt(rsaPub.getModulus());
            this.putMPInt(rsaPrv.getPrivateExponent());
            this.putMPInt(rsaPrv.getCrtCoefficient());
            this.putMPInt(rsaPrv.getPrimeQ());
            this.putMPInt(rsaPrv.getPrimeP());
        } else if (pubKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPub = (DSAPublicKey)pubKey;
            DSAParams dsaParams = dsaPub.getParams();
            DSAPrivateKey dsaPrv = (DSAPrivateKey)prvKey;
            this.putString("ssh-dss");
            this.putMPInt(dsaParams.getP());
            this.putMPInt(dsaParams.getQ());
            this.putMPInt(dsaParams.getG());
            this.putMPInt(dsaPub.getY());
            this.putMPInt(dsaPrv.getX());
        } else if (pubKey instanceof ECPublicKey) {
            ECPublicKey ecPub = (ECPublicKey)pubKey;
            ECPrivateKey ecPriv = (ECPrivateKey)prvKey;
            ECParameterSpec ecParams = ecPub.getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecParams);
            if (curve == null) {
                throw new BufferException("Unsupported EC curve parameters");
            }
            this.putString(curve.getKeyType());
            this.putString(curve.getName());
            this.putBytes(ECCurves.encodeECPoint(ecPub.getW(), ecParams));
            this.putMPInt(ecPriv.getS());
        } else {
            throw new BufferException("Unsupported key pair algorithm: " + kp.getPublic().getAlgorithm());
        }
    }

    protected void ensureCapacity(int capacity) {
        this.ensureCapacity(capacity, BufferUtils.DEFAULT_BUFFER_GROWTH_FACTOR);
    }

    public abstract void ensureCapacity(int var1, Int2IntFunction var2);

    protected abstract int size();

    public String toString() {
        return "Buffer [rpos=" + this.rpos() + ", wpos=" + this.wpos() + ", size=" + this.size() + "]";
    }
}

